<?php

namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\DBAL\FetchMode;
use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Migrates old translated properties to new fixed ones.
 */
class Version20200618151336 extends AbstractMigration
{

    protected $migrationSets = [
        'preselectedProperties' => [
            'gastronomyStyle:African' => 'gastronomyStyle:african',
            'gastronomyStyle:American' => 'gastronomyStyle:american',
            'gastronomyStyle:Arabian' => 'gastronomyStyle:arabic',
            'gastronomyStyle:Asian' => 'gastronomyStyle:asia',
            'gastronomyStyle:French' => 'gastronomyStyle:french',
            'gastronomyStyle:Greek' => 'gastronomyStyle:greek',
            'gastronomyStyle:Haute cuisine' => 'gastronomyStyle:haute_cuisine',
            'gastronomyStyle:Homelike' => 'gastronomyStyle:homely',
            'gastronomyStyle:Indian' => 'gastronomyStyle:india',
            'gastronomyStyle:International' => 'gastronomyStyle:india',
            'gastronomyStyle:Italian' => 'gastronomyStyle:italian',
            'gastronomyStyle:Japanese' => 'gastronomyStyle:japan',
            'gastronomyStyle:Mediterranean' => 'gastronomyStyle:mediteran',
            'gastronomyStyle:Mexican' => 'gastronomyStyle:mex',
            'gastronomyStyle:Oriental' => 'gastronomyStyle:oriental',
            'gastronomyStyle:Regional' => 'gastronomyStyle:regional',
            'gastronomyStyle:Spanish' => 'gastronomyStyle:spanish',
            'gastronomyStyle:Swiss' => 'gastronomyStyle:swiss',
            'gastronomyStyle:Traditional fare' => 'gastronomyStyle:traditional',
            'gastronomyStyle:Turkish' => 'gastronomyStyle:turkish',
            'gastronomyStyle:Afrikanisch' => 'gastronomyStyle:african',
            'gastronomyStyle:Amerikanisch' => 'gastronomyStyle:american',
            'gastronomyStyle:Arabisch' => 'gastronomyStyle:arabic',
            'gastronomyStyle:Asiatisch' => 'gastronomyStyle:asia',
            'gastronomyStyle:Französisch' => 'gastronomyStyle:french',
            'gastronomyStyle:Griechisch' => 'gastronomyStyle:greek',
            'gastronomyStyle:Haute Cuisine' => 'gastronomyStyle:haute_cuisine',
            'gastronomyStyle:Gutbürgerlich' => 'gastronomyStyle:homely',
            'gastronomyStyle:Indisch' => 'gastronomyStyle:india',
            'gastronomyStyle:Italienisch' => 'gastronomyStyle:italian',
            'gastronomyStyle:Japanisch' => 'gastronomyStyle:japan',
            'gastronomyStyle:Mediterran' => 'gastronomyStyle:mediteran',
            'gastronomyStyle:Mexikanisch' => 'gastronomyStyle:mex',
            'gastronomyStyle:Orientalisch' => 'gastronomyStyle:oriental',
            'gastronomyStyle:Spanisch' => 'gastronomyStyle:spanish',
            'gastronomyStyle:Schweizerisch' => 'gastronomyStyle:swiss',
            'gastronomyStyle:Traditionell' => 'gastronomyStyle:traditional',
            'gastronomyStyle:Türkisch' => 'gastronomyStyle:turkish',
            'gastronomyStyle:africain' => 'gastronomyStyle:african',
            'gastronomyStyle:Américaines' => 'gastronomyStyle:american',
            'gastronomyStyle:Arabe' => 'gastronomyStyle:arabic',
            'gastronomyStyle:Asiatique' => 'gastronomyStyle:asia',
            'gastronomyStyle:Française' => 'gastronomyStyle:french',
            'gastronomyStyle:Grecque' => 'gastronomyStyle:greek',
            'gastronomyStyle:Bourgeoise' => 'gastronomyStyle:homely',
            'gastronomyStyle:Indien' => 'gastronomyStyle:india',
            'gastronomyStyle:Internationale' => 'gastronomyStyle:international',
            'gastronomyStyle:Italienne' => 'gastronomyStyle:italian',
            'gastronomyStyle:Japonais' => 'gastronomyStyle:japan',
            'gastronomyStyle:Méditerranéenne' => 'gastronomyStyle:mediteran',
            'gastronomyStyle:mexicaine' => 'gastronomyStyle:mex',
            'gastronomyStyle:Régionale' => 'gastronomyStyle:regional',
            'gastronomyStyle:Espagnole' => 'gastronomyStyle:spanish',
            'gastronomyStyle:suisses' => 'gastronomyStyle:swiss',
            'gastronomyStyle:Cuisine traditionnelle' => 'gastronomyStyle:traditional',
            'gastronomyStyle:Turc' => 'gastronomyStyle:turkish',
            'gastronomyStyle:árabe' => 'gastronomyStyle:arabic',
            'gastronomyStyle:Asiática' => 'gastronomyStyle:asia',
            'gastronomyStyle:Francesa' => 'gastronomyStyle:french',
            'gastronomyStyle:Griega' => 'gastronomyStyle:greek',
            'gastronomyStyle:Alta cocina' => 'gastronomyStyle:haute_cuisine',
            'gastronomyStyle:Casera' => 'gastronomyStyle:homely',
            'gastronomyStyle:Hindú' => 'gastronomyStyle:india',
            'gastronomyStyle:Japonés' => 'gastronomyStyle:japan',
            'gastronomyStyle:Mediterránea' => 'gastronomyStyle:mediteran',
            'gastronomyStyle:mexicana' => 'gastronomyStyle:mex',
            'gastronomyStyle:Española' => 'gastronomyStyle:spanish',
            'gastronomyStyle:suizas' => 'gastronomyStyle:swiss',
            'gastronomyStyle:Cocina casera' => 'gastronomyStyle:traditional',
            'gastronomyStyle:Africano' => 'gastronomyStyle:african',
            'gastronomyStyle:Americana' => 'gastronomyStyle:american',
            'gastronomyStyle:Arabo' => 'gastronomyStyle:arabic',
            'gastronomyStyle:Asiatica' => 'gastronomyStyle:asia',
            'gastronomyStyle:Francese' => 'gastronomyStyle:french',
            'gastronomyStyle:Greca' => 'gastronomyStyle:greek',
            'gastronomyStyle:Casalinga' => 'gastronomyStyle:homely',
            'gastronomyStyle:Indiano' => 'gastronomyStyle:india',
            'gastronomyStyle:Italiana' => 'gastronomyStyle:italian',
            'gastronomyStyle:Giapponese' => 'gastronomyStyle:japan',
            'gastronomyStyle:Mediterranea' => 'gastronomyStyle:mediteran',
            'gastronomyStyle:messicana' => 'gastronomyStyle:mex',
            'gastronomyStyle:Orientale' => 'gastronomyStyle:oriental',
            'gastronomyStyle:Regionale' => 'gastronomyStyle:regional',
            'gastronomyStyle:Spagnola' => 'gastronomyStyle:spanish',
            'gastronomyStyle:svizzere' => 'gastronomyStyle:swiss',
            'gastronomyStyle:Casereccio' => 'gastronomyStyle:traditional',
            'gastronomyStyle:Turco' => 'gastronomyStyle:turkish',

            'habitsAndAllergies:On demand' => 'habitsAndAllergies:onDemand',
            'habitsAndAllergies:Organic/wholefood' => 'habitsAndAllergies:bio',
            'habitsAndAllergies:Gluten free food' => 'habitsAndAllergies:glutenFree',
            'habitsAndAllergies:Halal' => 'habitsAndAllergies:halal',
            'habitsAndAllergies:Kosher' => 'habitsAndAllergies:kosher',
            'habitsAndAllergies:Lactose free food' => 'habitsAndAllergies:lactoseFree',
            'habitsAndAllergies:Low-calorie dishes' => 'habitsAndAllergies:reduction',
            'habitsAndAllergies:Spezial diets (stomach, liver, gall, diabetes)' => 'habitsAndAllergies:specialDiet',
            'habitsAndAllergies:Vegan food' => 'habitsAndAllergies:vegan',
            'habitsAndAllergies:Vegetarian' => 'habitsAndAllergies:vegetarian',
            'habitsAndAllergies:Auf Anfrage' => 'habitsAndAllergies:onDemand',
            'habitsAndAllergies:Bio-, Vollwertküche' => 'habitsAndAllergies:bio',
            'habitsAndAllergies:Glutenfreie Kost' => 'habitsAndAllergies:glutenFree',
            'habitsAndAllergies:Koscher' => 'habitsAndAllergies:kosher',
            'habitsAndAllergies:Lactosefreie Kost' => 'habitsAndAllergies:lactoseFree',
            'habitsAndAllergies:Reduktionskost' => 'habitsAndAllergies:reduction',
            'habitsAndAllergies:Spezielle Diät (Magen, Leber, Galle, Diabetes)' => 'habitsAndAllergies:specialDiet',
            'habitsAndAllergies:Vegane Küche' => 'habitsAndAllergies:vegan',
            'habitsAndAllergies:Vegetarische Küche' => 'habitsAndAllergies:vegetarian',
            'habitsAndAllergies:Sur demande' => 'habitsAndAllergies:onDemand',
            'habitsAndAllergies:Cuisine bio, aux céréales complètes' => 'habitsAndAllergies:bio',
            'habitsAndAllergies:Repas sans gluten' => 'habitsAndAllergies:glutenFree',
            'habitsAndAllergies:Cacher' => 'habitsAndAllergies:kosher',
            'habitsAndAllergies:Repas sans lactose' => 'habitsAndAllergies:lactoseFree',
            'habitsAndAllergies:Prix réduit' => 'habitsAndAllergies:reduction',
            'habitsAndAllergies:Regime spécial (gastrique, hépatique,bile, diabète)' => 'habitsAndAllergies:specialDiet',
            'habitsAndAllergies:Cuisine végétalienne' => 'habitsAndAllergies:vegan',
            'habitsAndAllergies:Végétarienne' => 'habitsAndAllergies:vegetarian',
            'habitsAndAllergies:A petición' => 'habitsAndAllergies:onDemand',
            'habitsAndAllergies:Biológica, integral' => 'habitsAndAllergies:bio',
            'habitsAndAllergies:Alimentos sin gluten' => 'habitsAndAllergies:glutenFree',
            'habitsAndAllergies:Alimentos sin lactosa' => 'habitsAndAllergies:lactoseFree',
            'habitsAndAllergies:Dieta de reducción de peso' => 'habitsAndAllergies:reduction',
            'habitsAndAllergies:Dietas particulares (estómago, hígado, biliar, diabetes)' => 'habitsAndAllergies:specialDiet',
            'habitsAndAllergies:Comida vegana' => 'habitsAndAllergies:vegan',
            'habitsAndAllergies:Vegetariana' => 'habitsAndAllergies:vegetarian',
            'habitsAndAllergies:Su richiesta' => 'habitsAndAllergies:onDemand',
            'habitsAndAllergies:Biologica, integrale' => 'habitsAndAllergies:bio',
            'habitsAndAllergies:Cibi senza glutine' => 'habitsAndAllergies:glutenFree',
            'habitsAndAllergies:Cibi senza lattosio' => 'habitsAndAllergies:lactoseFree',
            'habitsAndAllergies:Riduzioni' => 'habitsAndAllergies:reduction',
            'habitsAndAllergies:Diete specifiche (stomaco, fegato, cistifellea, diabete)' => 'habitsAndAllergies:specialDiet',
            'habitsAndAllergies:Cucina vegana' => 'habitsAndAllergies:vegan',

            'kitchenStyle:Breakfast/brunch' => 'kitchenStyle:brunch',
            'kitchenStyle:Home-made cakes and gateaux' => 'kitchenStyle:cakes',
            'kitchenStyle:Large selection of cocktails' => 'kitchenStyle:cocktail',
            'kitchenStyle:Coffee & cake' => 'kitchenStyle:coffee_and_cake',
            'kitchenStyle:Diet cuisine' => 'kitchenStyle:diet',
            'kitchenStyle:Evening meal' => 'kitchenStyle:dining',
            'kitchenStyle:Fish specialities' => 'kitchenStyle:fish',
            'kitchenStyle:Fondue / Raclette / cheese' => 'kitchenStyle:fondue',
            'kitchenStyle:Game specialities' => 'kitchenStyle:game',
            'kitchenStyle:Ice-cream menu' => 'kitchenStyle:ice',
            'kitchenStyle:Lunch menu' => 'kitchenStyle:lunch',
            'kitchenStyle:meat specialties' => 'kitchenStyle:meat',
            'kitchenStyle:Regional specialities' => 'kitchenStyle:regional',
            'kitchenStyle:Seasonal dishes' => 'kitchenStyle:seasonal',
            'kitchenStyle:Snack menu' => 'kitchenStyle:snack',
            'kitchenStyle:Steak menu' => 'kitchenStyle:steak',
            'kitchenStyle:Large selection of vegetarian dishes' => 'kitchenStyle:vegetarian',
            'kitchenStyle:Large selection of wines' => 'kitchenStyle:wine',
            'kitchenStyle:Frühstück/Brunch' => 'kitchenStyle:brunch',
            'kitchenStyle:Hausgemachte Kuchen und Torten' => 'kitchenStyle:cakes',
            'kitchenStyle:Große Cocktailauswahl' => 'kitchenStyle:cocktail',
            'kitchenStyle:Kaffee & Kuchen' => 'kitchenStyle:coffee_and_cake',
            'kitchenStyle:Diätküche' => 'kitchenStyle:diet',
            'kitchenStyle:Abendessen' => 'kitchenStyle:dining',
            'kitchenStyle:Fischspezialitäten' => 'kitchenStyle:fish',
            'kitchenStyle:Fondue / Raclette / Käse' => 'kitchenStyle:fondue',
            'kitchenStyle:Wildspezialitäten' => 'kitchenStyle:game',
            'kitchenStyle:Eiskarte' => 'kitchenStyle:ice',
            'kitchenStyle:Mittagstisch' => 'kitchenStyle:lunch',
            'kitchenStyle:Fleischspezialitäten' => 'kitchenStyle:meat',
            'kitchenStyle:Regionale Spezialitäten' => 'kitchenStyle:regional',
            'kitchenStyle:Saisonale Gerichte' => 'kitchenStyle:seasonal',
            'kitchenStyle:Vesperkarte/Brotzeitkarte' => 'kitchenStyle:snack',
            'kitchenStyle:Steakkarte' => 'kitchenStyle:steak',
            'kitchenStyle:Große vegetarische Auswahl' => 'kitchenStyle:vegetarian',
            'kitchenStyle:Große Weinauswahl' => 'kitchenStyle:wine',
            'kitchenStyle:Petit-déjeuner/brunch' => 'kitchenStyle:brunch',
            'kitchenStyle:Gâteaux et tartes faits maison' => 'kitchenStyle:cakes',
            'kitchenStyle:Grand choix de cocktails' => 'kitchenStyle:cocktail',
            'kitchenStyle:Café et gâteaux' => 'kitchenStyle:coffee_and_cake',
            'kitchenStyle:Cuisine diététique' => 'kitchenStyle:diet',
            'kitchenStyle:Dîner' => 'kitchenStyle:dining',
            'kitchenStyle:Spécialités de poisson' => 'kitchenStyle:fish',
            'kitchenStyle:Fondue / Raclette / fromage' => 'kitchenStyle:fondue',
            'kitchenStyle:Spécialités de gibier' => 'kitchenStyle:game',
            'kitchenStyle:Glaces' => 'kitchenStyle:ice',
            'kitchenStyle:Déjeuner' => 'kitchenStyle:lunch',
            'kitchenStyle:spécialités de viande' => 'kitchenStyle:meat',
            'kitchenStyle:Spécialités régionales' => 'kitchenStyle:regional',
            'kitchenStyle:Plats saisonniers' => 'kitchenStyle:seasonal',
            'kitchenStyle:Carte pains avec charcuterie/fromage' => 'kitchenStyle:snack',
            'kitchenStyle:Steaks' => 'kitchenStyle:steak',
            'kitchenStyle:Grand choix de plats végétariens' => 'kitchenStyle:vegetarian',
            'kitchenStyle:Grand choix de vins' => 'kitchenStyle:wine',
            'kitchenStyle:Desayunos/brunchs' => 'kitchenStyle:brunch',
            'kitchenStyle:Pastelería y repostería caseras' => 'kitchenStyle:cakes',
            'kitchenStyle:Gran selección de cócteles' => 'kitchenStyle:cocktail',
            'kitchenStyle:Café y pasteles' => 'kitchenStyle:coffee_and_cake',
            'kitchenStyle:Cocina dietética' => 'kitchenStyle:diet',
            'kitchenStyle:Cena' => 'kitchenStyle:dining',
            'kitchenStyle:Especialidades en pescado' => 'kitchenStyle:fish',
            'kitchenStyle:Fondue / Raclette / queso' => 'kitchenStyle:fondue',
            'kitchenStyle:Especialidades de caza' => 'kitchenStyle:game',
            'kitchenStyle:Carta de helados' => 'kitchenStyle:ice',
            'kitchenStyle:Almuerzos de mediodía' => 'kitchenStyle:lunch',
            'kitchenStyle:especialidades de carne' => 'kitchenStyle:meat',
            'kitchenStyle:Especialidades regionales' => 'kitchenStyle:regional',
            'kitchenStyle:Platos de temporada' => 'kitchenStyle:seasonal',
            'kitchenStyle:Carta de platos ligeros, estilo merendero' => 'kitchenStyle:snack',
            'kitchenStyle:Carta de carnes' => 'kitchenStyle:steak',
            'kitchenStyle:Gran selección vegetariana' => 'kitchenStyle:vegetarian',
            'kitchenStyle:Gran selección de vinos' => 'kitchenStyle:wine',
            'kitchenStyle:Clazione/brunch' => 'kitchenStyle:brunch',
            'kitchenStyle:Torte e dolci fatti in casa' => 'kitchenStyle:cakes',
            'kitchenStyle:Ampia scelta di cocktail' => 'kitchenStyle:cocktail',
            'kitchenStyle:Caffè e dolcetti' => 'kitchenStyle:coffee_and_cake',
            'kitchenStyle:Cucina dietetica' => 'kitchenStyle:diet',
            'kitchenStyle:Specialità pesce' => 'kitchenStyle:fish',
            'kitchenStyle:Fondue / Raclette / formaggio' => 'kitchenStyle:fondue',
            'kitchenStyle:Specialità selvaggina' => 'kitchenStyle:game',
            'kitchenStyle:Specialità gelati' => 'kitchenStyle:ice',
            'kitchenStyle:Aperto a mezzogiorno' => 'kitchenStyle:lunch',
            'kitchenStyle:specialità di carne' => 'kitchenStyle:meat',
            'kitchenStyle:Specialità regionali' => 'kitchenStyle:regional',
            'kitchenStyle:Piatti di stagione' => 'kitchenStyle:seasonal',
            'kitchenStyle:Menu serale' => 'kitchenStyle:snack',
            'kitchenStyle:Specialità carne' => 'kitchenStyle:steak',
            'kitchenStyle:Ampia scelta vegetariana' => 'kitchenStyle:vegetarian',
            'kitchenStyle:Ampia scelta di vini' => 'kitchenStyle:wine',

            'priceSegment:hoch' => 'priceSegment:high',
            'priceSegment:niedrig' => 'priceSegment:low',
            'priceSegment:mittel' => 'priceSegment:medium',
            'priceSegment:élevé' => 'priceSegment:high',
            'priceSegment:faible' => 'priceSegment:low',
            'priceSegment:moyen' => 'priceSegment:medium',
            'priceSegment:alto' => 'priceSegment:high',
            'priceSegment:bajo' => 'priceSegment:low',
            'priceSegment:medio' => 'priceSegment:medium',
            'priceSegment:alta' => 'priceSegment:high',
            'priceSegment:basso' => 'priceSegment:low',

            'services:Ball/function rooms' => 'services:ball',
            'services:billiards' => 'services:billiard',
            'services:bowling alley/bowling' => 'services:bowling',
            'services:Bus parking available' => 'services:bus',
            'services:Catering' => 'services:catering',
            'services:Darts' => 'services:darts',
            'services:Dogs welcome' => 'services:dog',
            'services:E-Bike Akku-Ladestation' => 'services:ebike',
            'services:Frontcooking' => 'services:frontcooking',
            'services:GroupsWelcome welcome' => 'services:groupsWelcome',
            'services:Handicapped accessible (restaurant and toilets accessible by wheelchair)' => 'services:handicap_accessible',
            'services:Hiking trails close at hand' => 'services:hiking',
            'services:Home delivery service' => 'services:homeservice',
            'services:Live music' => 'services:livemusic',
            'services:All-day dining' => 'services:never_cold',
            'services:Nette Toilette' => 'services:nice_wc',
            'services:Nightlife' => 'services:nightlife',
            'services:Available accommodation (rooms/holiday apartments)' => 'services:overnight',
            'services:Farm shop selling own products' => 'services:own_products',
            'services:Adjacent car park' => 'services:parking',
            'services:Patio, garden' => 'services:patio',
            'services:No pets allowed' => 'services:pets_not_allowed',
            'services:Caan be reached by public transport' => 'services:public_transit',
            'services:We mainly use regional products' => 'services:regional',
            'services:Reservations recommended' => 'services:reservation',
            'services:Smokers’ room' => 'services:smoking',
            'services:table football' => 'services:tablefootball',
            'services:Takeaway' => 'services:takeaway',
            'services:Tearoom' => 'services:tearoom',
            'services:W-Lan' => 'services:wifi',
            'services:Festsäle/Gesellschaftsräume' => 'services:ball',
            'services:Billard' => 'services:billiard',
            'services:Kegelbahn/Bowling' => 'services:bowling',
            'services:Busparkplätze vorhanden' => 'services:bus',
            'services:Dart' => 'services:darts',
            'services:Hunde willkommen' => 'services:dog',
            'services:Reisegruppen willkommen' => 'services:groupsWelcome',
            'services:Behindertengerecht (Lokal und Toiletten mit Rollstuhl erreichbar)' => 'services:handicap_accessible',
            'services:Wanderwege am Haus vorbei' => 'services:hiking',
            'services:Heimlieferservice' => 'services:homeservice',
            'services:Live Musik' => 'services:livemusic',
            'services:Durchgehend warme Küche' => 'services:never_cold',
            'services:Übernachtungsmöglichkeiten (Zimmer/Ferienwohnungen)' => 'services:overnight',
            'services:Hofladen, Verkauf eigener Produkte' => 'services:own_products',
            'services:Parkmöglichkeiten am Haus' => 'services:parking',
            'services:Terrasse, Garten' => 'services:patio',
            'services:Haustiere nicht erlaubt' => 'services:pets_not_allowed',
            'services:Mit öffentlichen Verkehrsmitteln zu erreichen' => 'services:public_transit',
            'services:Wir verwenden hauptsächlich regionale Produkte' => 'services:regional',
            'services:Reservierung empfohlen' => 'services:reservation',
            'services:Raucherraum' => 'services:smoking',
            'services:Tischfußball' => 'services:tablefootball',
            'services:Take Away' => 'services:takeaway',
            'services:Tea-Room' => 'services:tearoom',
            'services:Salle pour fêtes/locaux de réunion' => 'services:ball',
            'services:billard' => 'services:billiard',
            'services:bolwing' => 'services:bowling',
            'services:Emplacements de parking pour bus' => 'services:bus',
            'services:Service de traiteur' => 'services:catering',
            'services:jeu de fléchettes' => 'services:darts',
            'services:Chiens bienvenus' => 'services:dog',
            'services:Voyages organisés bienvenus' => 'services:groupsWelcome',
            'services:Equipement pour handicapés (restaurant et toilettes accessibles en fauteuil roulant)' => 'services:handicap_accessible',
            'services:Sentiers de randonnée près de l’établissement' => 'services:hiking',
            'services:Service de livraison à domicile' => 'services:homeservice',
            'services:Musique live' => 'services:livemusic',
            'services:Service continu' => 'services:never_cold',
            'services:Possibilités de logement (chambres/appartements de vacances)' => 'services:overnight',
            'services:Vente à la ferme' => 'services:own_products',
            'services:Possibilités de parking devant l’établissement' => 'services:parking',
            'services:Terrasse, jardin' => 'services:patio',
            'services:Animaux domestiques non admis' => 'services:pets_not_allowed',
            'services:Accessible avec les transports publics' => 'services:public_transit',
            'services:Nous utilisons principalement des produits régionaux' => 'services:regional',
            'services:Réservation recommandée' => 'services:reservation',
            'services:Salle pour fumeurs' => 'services:smoking',
            'services:football de table' => 'services:tablefootball',
            'services:Vente à emporter' => 'services:takeaway',
            'services:Salon de thé' => 'services:tearoom',
            'services:Sala de fiestas/salones privados' => 'services:ball',
            'services:billar' => 'services:billiard',
            'services:bolera' => 'services:bowling',
            'services:Aparcamiento para autocares' => 'services:bus',
            'services:dardos' => 'services:darts',
            'services:Se aceptan perros' => 'services:dog',
            'services:Adecuado para viajes organizados' => 'services:groupsWelcome',
            'services:Adaptado para minusválidos (comedor y servicios accesibles con silla de ruedas)' => 'services:handicap_accessible',
            'services:Senderos de excursión junto a la casa' => 'services:hiking',
            'services:Vida nocturna' => 'services:nightlife',
            'services:Posibilidad de pernoctación (habitaciones / apartamentos)' => 'services:overnight',
            'services:Posibilidad de aparcamiento' => 'services:parking',
            'services:Terraza, jardín' => 'services:patio',
            'services:No se permiten animales' => 'services:pets_not_allowed',
            'services:Transporte público local cercano' => 'services:public_transit',
            'services:Utilizamos principalmente productos regionales' => 'services:regional',
            'services:Reservas recomendado' => 'services:reservation',
            'services:Sala de fumadores' => 'services:smoking',
            'services:futbolín' => 'services:tablefootball',
            'services:Saloni per feste o riunioni' => 'services:ball',
            'services:biliardo' => 'services:billiard',
            'services:bowling' => 'services:bowling',
            'services:Parcheggio per pullman' => 'services:bus',
            'services:freccetta' => 'services:darts',
            'services:Si accettano cani' => 'services:dog',
            'services:Si accettano gruppi' => 'services:groupsWelcome',
            'services:Conforme ai portatori di handicap (sala pranzo e WC raggiungibili in carrozzina)' => 'services:handicap_accessible',
            'services:Posizione lungo sentieri' => 'services:hiking',
            'services:Vita notturna' => 'services:nightlife',
            'services:Possibilità di pernottamento (camere/appartamenti per vacanze)' => 'services:overnight',
            'services:Parcheggio' => 'services:parking',
            'services:Terrazza, giardino' => 'services:patio',
            'services:Animali domestici non permessi' => 'services:pets_not_allowed',
            'services:Raggiungibile con mezzi pubblici' => 'services:public_transit',
            'services:Utilizziamo principalmente prodotti regionali' => 'services:regional',
            'services:Prenotazione consigliata' => 'services:reservation',
            'services:Sala fumatori' => 'services:smoking',
            'services:calcetto' => 'services:tablefootball',

            'services:mit öffentlichen Verkehrsmitteln zu erreichen' => 'services:public_transit',
            'services:Gläserne Produktion' => 'services:publicly_observable_production',
            'services:Behindertengerecht' => 'services:handicap_accessible',
            'services:Übernachtungsmöglichkeiten' => 'services:overnight',
            'services:Produkte aus ökologischem Anbau' => 'services:ecological_products',

            'information:Barrierefrei' => 'information:handicap_accessible',
            'information:PKW Parkplatz' => 'information:parking',
            'information:Familienfreundlich' => 'information:suitable_for_families',
            'information:Seniorenfreundlich' => 'information:suitable_for_seniors',
            'information:Schlechtwetter geeignet' => 'information:suitable_for_bad_weather',
            'information:WLAN' => 'information:wifi',
            'information:suitable for the disabled' => 'information:handicap_accessible',
            'information:suitable bad weather' => 'information:suitable_for_bad_weather',
            'information:bus park' => 'information:bus_parking',
            'information:family-friendly' => 'information:suitable_for_families',
            'information:car park' => 'information:parking',
            'information:Seniors friendly' => 'information:suitable_for_seniors',
            'information:adapté(e) aux handicapés' => 'information:handicap_accessible',
            'information:approprié intempéries' => 'information:suitable_for_bad_weather',
            'information:favorable aux familles' => 'information:suitable_for_families',
            'information:parking' => 'information:parking',
            'information:Conforme aux personnes âgées' => 'information:suitable_for_seniors',

            'shopping:At the farm' => 'shopping:farm',
            'shopping:Shop' => 'shopping:shop',
            'shopping:Home delivery' => 'shopping:home_delivery',
            'shopping:Postal shipping' => 'shopping:postal_shipping',
            'shopping:Market' => 'shopping:market',
            'shopping:Auf dem Hof' => 'shopping:farm',
            'shopping:Ladengeschäft' => 'shopping:shop',
            'shopping:Lieferservice' => 'shopping:home_delivery',
            'shopping:Postversand' => 'shopping:postal_shipping',
            'shopping:Wochen- / Bauernmarkt' => 'shopping:market',

            'distinctions:Bioland' => 'distinctions:bioland',
            'distinctions:Demeter' => 'distinctions:demeter',
            'distinctions:Ecovin' => 'distinctions:ecovin',
            'distinctions:EU-Bio-Siegel' => 'distinctions:eu_bio',
            'distinctions:Naturland' => 'distinctions:naturland',

            'meats:Lamm' => 'meats:lamb',
            'meats:Rind' => 'meats:beef',
            'meats:Schwein' => 'meats:pork',
            'meats:Ziege' => 'meats:goat',
            'meats:Wild' => 'meats:deer',
            'meats:Kaninchen' => 'meats:rabbit',

            'fish:Eier' => 'fish:eggs',
            'fish:Ente' => 'fish:duck',
            'fish:Gans' => 'fish:goose',
            'fish:Hähnchen / Hühner' => 'fish:chicken',
            'fish:Pute' => 'fish:turkey',
            'fish:Fisch' => 'fish:fish',

            'drinks:Saft / Sirup' => 'drinks:juice',
            'drinks:Sekt' => 'drinks:sparkling_wine',
            'drinks:Schnaps / Brände / Liköre' => 'drinks:liquor',
            'drinks:Wein' => 'drinks:wine',
            'drinks:Bier' => 'drinks:beer',

            'vegetables:Äpfel' => 'vegetables_and_fruits:apple',
            'vegetables:Kartoffeln' => 'vegetables_and_fruits:potato',
            'vegetables:Beeren-/Steinobst' => 'vegetables_and_fruits:berry',
            'vegetables:Birnen' => 'vegetables_and_fruits:pear',
            'vegetables:Eingelegtes Gemüse / Obst' => 'vegetables_and_fruits:pickledVegetables',
            'vegetables:Kräuter' => 'vegetables_and_fruits:herbs',
            'vegetables:Gemüse / Salat' => 'vegetables_and_fruits:salad',
            'vegetables:Gewürze / Tee' => 'vegetables_and_fruits:tea',

            'oil:Honig' => 'oils_and_spreads:honey',
            'oil:Öl / Essig' => 'oils_and_spreads:oil_and_vinegar',
            'oil:Marmelade / Gelees' => 'oils_and_spreads:jam',
            'oil:Brotaufstriche' => 'oils_and_spreads:spread',

            'milk:Eis' => 'milk:ice_cream',
            'milk:Käse' => 'milk:sheep',
            'milk:Frischmilch' => 'milk:milk',
            'milk:Quark' => 'milk:quark',
            'milk:Ziegenprodukte' => 'milk:goat',
            'milk:Joghurt' => 'milk:yoghurt',

            'cereals:Nudeln' => 'grains:noodles',
            'cereals:Brot / Brötchen / Gebäck' => 'grains:bread',
            'cereals:Nüsse' => 'grains:nuts',
            'cereals:Getreide / Mehl' => 'grains:flour',
            'cereals:Hülsenfrüchte' => 'grains:legumes',

            'seasonals:Kürbis' => 'seasonals:pumpkin',
            'seasonals:Weihnachtsbäume/-schmuck' => 'seasonals:christmas_decoration',
            'seasonals:Erdbeeren' => 'seasonals:strawberries',
            'seasonals:Spargel' => 'seasonals:asparagus',
            'seasonals:Neuer Süßer' => 'seasonals:sweet_wine',

            'crafts:Felle' => 'crafts:fur',
            'crafts:Kosmetik / Seife' => 'crafts:cosmetics',
            'crafts:Blumen / Floristik' => 'crafts:flowers',
            'crafts:Deko-/ Geschenkartikel' => 'crafts:decorations',
            'crafts:Glaswaren / Glaskunst' => 'crafts:glass',
            'crafts:Töpferware / Keramik' => 'crafts:ceramic',
            'crafts:Kerzen' => 'crafts:candles',
            'crafts:Schmiedearbeiten' => 'crafts:wrought',
            'crafts:Schmuck' => 'crafts:jewellery',
            'crafts:Flechtarbeiten / Körbe' => 'crafts:weaving',
            'crafts:Textilien & Textilkunst' => 'crafts:textiles',
            'crafts:Malerei & Skulpturen' => 'crafts:arts',
            'crafts:Schnitzarbeiten' => 'crafts:wood_carving',
            'crafts:Wolle /Wollpodukte' => 'crafts:wool',
        ],
    ];

    public function up(Schema $schema)
    {
        $this->findChangesAndUpdate(false);
    }

    public function down(Schema $schema)
    {
        $this->findChangesAndUpdate(true);
    }

    private function findChangesAndUpdate(bool $reverse = false): void
    {
        $sql = '
            UPDATE neos_contentrepository_domain_model_nodedata
            SET properties=:properties
            WHERE persistence_object_identifier=:id
        ';

        foreach ($this->findChanges($reverse) as $id => $properties) {
            $this->addSql($sql, compact('id', 'properties'));
        }
    }

    private function findChanges(bool $reverse = false): array
    {
        $changes = [];

        $result = $this->connection->executeQuery('
            SELECT persistence_object_identifier, properties
            FROM neos_contentrepository_domain_model_nodedata
            WHERE nodetype LIKE "Newland.Toubiz.Poi.Neos:%"
        ');

        while ($row = $result->fetch(FetchMode::STANDARD_OBJECT)) {
            $properties = json_decode($row->properties, false);
            $hasChanges = false;
            foreach ($this->migrationSets as $property => $valueMap) {
                $valueMap = $reverse ? array_flip($valueMap) : $valueMap;

                if (!property_exists($properties, $property)) {
                    continue;
                }

                foreach ($properties->{$property} as $index => $value) {
                    if (!array_key_exists($value, $valueMap)) {
                        continue;
                    }

                    $hasChanges = true;
                    $properties->{$property}->{$index} = $valueMap[$value];
                }
            }

            if (!$hasChanges) {
                continue;
            }

            $changes[$row->persistence_object_identifier] = json_encode($properties);
        }

        return $changes;
    }
}
