<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\ErrorHandling;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Importer\ArticleImporter;
use Newland\Toubiz\Sync\Neos\Logging\LoggerFactory;
use Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock\ArticleAdapterMock;
use Psr\Log\LogLevel;
use Psr\Log\Test\TestLogger;

class LogImportErrorAndCarryOnTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    public function testInvalidDataErrorsAreNotPassedThroughToDoctrine(): void
    {
        $logger = new TestLogger();
        $factory = $this->createMock(LoggerFactory::class);
        $factory->method('getLogger')->willReturn($logger);

        $importer = $this->objectManager->get(ArticleImporter::class);
        $importer->injectLogger($factory);

        // Without the aspect this would throw an exception inside of doctrine
        // because the db refuses to save a record with a field that's to large.
        $importer->import(new ArticleAdapterMock([ 'name' => str_repeat('.', 1000) ]));

        // Instead it should be a validation error that is only logged.
        $this->assertTrue(
            $logger->hasRecordThatContains('Error validating Article', LogLevel::ERROR)
        );
    }

}
