<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Domain\Model;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\ZipCode;

class ZipCodeTest extends FunctionalTestCase
{

    /** @dataProvider provideUuids */
    public function testUsesReproducibleUuids(string $zip, ?string $country, string $uuid): void
    {
        $model = new ZipCode();
        $model->setZipCode($zip);
        $model->setCountry($country);

        $this->assertEquals(
            $uuid,
            $model->generateUuid()->toString(),
            'persistence object identifier should be stable: If this test fails then the'
            . ' way ids are being generated has probably changed and old identifiers need to be migrated'
            . ' to this new style.'
        );
    }

    public function provideUuids(): array
    {
        return [
            [ '12345', 'DE', '8f08c55b-3e9a-5033-9953-079a39d44533' ],
            [ '12345', 'US', '8964822c-53fd-5d8a-92cd-647557a087b0' ],
            [ '12345', null, '990bcbcf-8bbd-5426-934c-abf8348b4e8b' ],
            [ 'AB-123', 'DE', '562ca30f-6350-5411-8954-ebe51b8b3dd3' ],
        ];
    }

}
