<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model\Traits;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Tests\UnitTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Model\Medium;

class SortableRelationsTraitTest extends UnitTestCase
{
    /**
     * @var Article
     */
    protected $subject;

    /**
     * @var array
     */
    protected $media;

    /**
     * @var array
     */
    protected $sortingAsInDatabase = [
        'B',
        'D',
        'A',
        'C',
    ];

    /**
     * @var array
     */
    protected $manualSorting = [
        'A',
        'B',
        'C',
        'D',
    ];

    public function setUp()
    {
        $this->subject = new Article();
        $this->generateMedia();
    }

    public function testSortingOfMedia()
    {
        $sortedObjects = $this->subject->sortObjects($this->media, 'originalId', $this->manualSorting);
        $sortedIds = array_map(
            function (Medium $medium) {
                return $medium->getOriginalId();
            },
            $sortedObjects
        );

        $this->assertEquals($this->manualSorting, $sortedIds);
    }

    private function generateMedia()
    {
        $media = [];
        foreach ($this->sortingAsInDatabase as $originalId) {
            $medium = new Medium();
            $medium->setOriginalId($originalId);
            $media[] = $medium;
        }

        $this->media = $media;
    }
}
