<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Newland\Toubiz\Sync\Neos\Domain\Model\Slope;

/**
 * @method Slope create(array $properties = [])
 */
class SlopeFactory extends AbstractFactory
{
    public function make(array $properties = []): Slope
    {
        $slope = new Slope();

        $slope->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $slope->setName($properties['name'] ?? $this->faker->name);
        $slope->setStatus($properties['status'] ?? 0);
        $slope->setType($properties['type'] ?? 0);
        $slope->setDifficulty($properties['difficulty'] ?? 0);

        return $slope;
    }
}
