<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Doctrine\Common\Collections\ArrayCollection;
use Newland\Toubiz\Sync\Neos\Domain\Model\Region;

/**
 * @method Region create(array $properties = [])
 */
class RegionFactory extends AbstractFactory
{
    public function make(array $properties = []): Region
    {
        $region = new Region();

        $region->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $region->setName($properties['name'] ?? $this->faker->name);
        $region->setAttributes($properties['attributes'] ?? []);
        $region->setUpdatedAt($properties['updatedAt'] ?? new \DateTime);

        if (array_key_exists('slopes', $properties)) {
            $region->setSlopes(new ArrayCollection($properties['slopes']));
        }
        if (array_key_exists('transportationFacilities', $properties)) {
            $region->setTransportationFacilities(new ArrayCollection($properties['transportationFacilities']));
        }

        return $region;
    }
}
