<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Doctrine\Common\Collections\ArrayCollection;
use Newland\Toubiz\Sync\Neos\Domain\Model\CityData;

class CityDataFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $cityData = new CityData();

        $cityData->setIdTomas($properties['idThomas'] ?? $this->faker->uuid);
        $cityData->setIdToubiz($properties['idToubiz'] ?? $this->faker->uuid);
        if (array_key_exists('zipCodes', $properties)) {
            $zipCodes = array_map(function($zip) {
                if (\is_string($zip) || \is_int($zip)) {
                    return (new ZipCodeFactory($this->objectManager))
                        ->findOrCreate($zip);
                }
                return $zip;
            }, $properties['zipCodes']);
            $cityData->setZipCodes(new ArrayCollection($zipCodes));
        }

        return $cityData;
    }

}
