<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Newland\Toubiz\Sync\Neos\Domain\Model\Address;

class AddressFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $address = new Address();

        $address->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $address->setName($properties['name'] ?? $this->faker->name);
        $address->setZip($properties['zip'] ?? $this->faker->postcode);
        $address->setWebsiteAddress($properties['websiteAddress'] ?? $this->faker->url);
        $address->setPhoneNumber($properties['phoneNumber'] ?? $this->faker->phoneNumber);
        $address->setEmailAddress($properties['emailAddress'] ?? $this->faker->email);
        $address->setCountry($properties['country'] ?? $this->faker->country);
        $address->setStreet($properties['street'] ?? $this->faker->streetName);
        $address->setFirstName($properties['firstName'] ?? $this->faker->firstName);
        $address->setLastName($properties['lastName'] ?? $this->faker->lastName);
        $address->setLatitude($properties['latitude'] ?? $this->faker->latitude);
        $address->setLongitude($properties['longitude'] ?? $this->faker->longitude);

        if ($properties['language'] ?? false) {
            $address->setLanguage($properties['language']);
        }

        return $address;
    }

    protected function className(): string
    {
        return Address::class;
    }

    public function properties(array $properties): array
    {
        // TODO: Implement properties() method.
    }
}
