# Toubiz sync package

Provides functionality to synchronize API data into Neos CMS.

1. [Settings](#settings)
2. [Downloading images](#downloading-images)
3. [Settings for services](#configure-settings-for-services-offer-packages-guide)
4. [Importing](#importing-from-toubiz-apiv1)
5. [Cloadflare](#cloudflare-cache)

## Configuration

### Settings
Configure available services (data sources) inside `Settings.yaml`. The following configuration demonstrates available service configurations.

```
Newland:
  Toubiz:
    Sync:
      Neos:
        services:
          Toubiz/Legacy/EventApi:
            clients:
              default:
                client: ''
                apiKey: ''
                organizer: ''
                languages:
                  - de
                  - en
                detailUriTemplates:
                    rce: 'https://www.foobar.com/region/?eventID={rceEventId}&dateID={rceDateId}&mode=DT&redirect=1'

          Toubiz/Legacy/Db:
            clients:
              default:
                client: ''
                apiKey: ''
                minLevelOfMaintenance: 60

          Toubiz/Legacy/Tportal:
            clients:
              default:
                client: ''
                apikey: ''

          Sisag/Api:
            clients:
              default:
                client: ''

          Tportal/CongressApi:
            clients:
              default:
                client: mytportalclient
                detailUri: 'https://foobar.com/{tportalUriSegment}'

          Tportal/Api:
            clients:
              default:
                client: mytportalclient
                detailUri: 'https://foobar.com/{tportalUriSegment}'
```

#### Configure weather data provider

Toubiz sync package supports 2 providers for weather data: "Meteotest" and "OpenWeatherMap".

Example configuration for "Meteotest":

```
Newland:
  Toubiz:
    Sync:
      Neos:
        dataProvider:
          weather: meteotest
        services:
          Meteotest/Api:
            clients:
              default:
                apiKey: MYAPIKEY
                parameters:
                  action: my_preconfigured_action
```

Example configuration for "OpenWeatherMap":

```
Newland:
  Toubiz:
    Sync:
      Neos:
        dataProvider:
          weather: openweathermap
        services:
          OpenWeatherMap/Api:
            clients:
              default:
                apiKey: myapikey
                parameters:
                  locations:
                    Paris:
                      lat: 48.8588376
                      lon: 2.2768489
                    Tokyo:
                      lat: 35.669107
                      lon: 139.6009544
                    Sulzburg:
                      lat: 47.8277304
                      lon: 7.6954458
```

#### Configure Geo Location Service

If a data provider supplied geo coordinates but no physical address, you can use a geo location
service to retrieve the zip code during import.

```
Newland:
  Toubiz:
    Sync:
      Neos:
        services:
          'GeoLocation': 'Newland\Toubiz\Sync\Neos\Geometry\LocalLocationService'
```

The following providers exist:
- `Newland\Toubiz\Sync\Neos\Geometry\LocalLocationService`: Gets data out of a local mysql database.
  For this to work correctly you have to execute the `geometry:seedZipPolygons` first in order to setup
  the location database.
- `Newland\Toubiz\Api\Service\GeoLocation\NominatimService`: Uses the nominatim OpenStreetMaps API.
  Only use this provider for testing purposes.
- `Newland\Toubiz\Api\Service\GeoLocation\NullService`: Does nothing.


### Downloading Images

By default images are referenced from their remote URL (e.g. the URL of toubiz / outdooractive / ...). You can set `Newland.Toubiz.Sync.Neos.downloadImages.{*}` to `true` in order to download the images to the webserver upon import in order to improve their availability. This will come at cost of hard drive space though - do not use this option if you are importing lots of data.

### Configure settings for Services (offer, packages, guide)
Services are imported using the same Tportal settings as lodgings. Single Tportal modules can be activated/deactivated separately.
In cases it might happen that e.g. available languages differ for the different types.
Different clients can be used to solve this issue:

```yaml
Newland:
  Toubiz:
    Sync:
      Neos:
        services:
          Tportal/Api:
            clients:
              # More languages available for lodging than for the other Tportal modules
              # Client name can always be chosen arbitrarily
              Lodging:
                baseUri: https://mc-14.lis-cms.de
                client: clientName
                detailUri: '/{tportalUriSegment}?lang={languageSegment}'
                languages: [ 'de', 'en', 'fr', 'es', 'it' ]
                lodgings: true
                offers: false
                packages: false
                guides: false
              Services:
                baseUri: https://mc-14.lis-cms.de
                client: clientName
                detailUri: '/{tportalUriSegment}?lang={languageSegment}'
                languages: [ 'de', 'en' ]
                lodgings: false
                offers: true
                packages: true
                guides: false
```

### Importing from Toubiz APIv1

Importing from the new toubiz (APIv1) is a bit more flexible than other imports: You define a single set of credentials
for multiple types of articles that are being imported. Additionally, you define sets of filters. In it's easiest form 
the following configuration will apply default filters for the types being specified:

```yaml
Newland:
  Toubiz:
    Sync:
      Neos:
        services: 
          Toubiz/ApiV1/Article:
            clients:
              san-flamingo:
                client: 'd8a1d47d-3192-4d8e-bf80-1b4d1404f8d1'
                apiKey: '...'
                import:
                  - type: cities
                  - type: poi
                  - type: gastronomy
                  - type: lodgings
                  - type: tours
                  - type: directMarketers
                  - type: congressLocations
```

If you want to be more specific however, you can specify a set of request filters in each item in `import`:
(You can see all filter possibilities in the [APIv1 Documentation](https://mein.toubiz.de/api/v1/docs?internal=1#api-v1-article-index))

```yaml
Newland:
  Toubiz:
    Sync:
      Neos:
        services: 
          Toubiz/ApiV1/Article:
            clients:
              san-flamingo:
                client: 'd8a1d47d-3192-4d8e-bf80-1b4d1404f8d1'
                apiKey: '...'
                import:
                  # All POIs in a 10km radius around the city (including open ones)
                  - type: poi
                    request:
                      filter:
                        category: '4c5fffa9-b6df-4ca6-98aa-063d848b4e0b'
                        location:
                          latitude: 48.0479013
                          longitude: 8.1365212
                          radiusMeters: 10000
```

### Cloudflare cache

API Documentation: https://developers.cloudflare.com/api/operations/zone-purge

If your project uses Cloudflare caching, you can add backend UI buttons
to purge single pages (or everything) on demand.

Add the cloudflare credentials to your project.

**IMPORTANT**: Generate a new API token within cloudflare,
with permissions to ONLY purge caches. DO NOT use the default admin API token!

```
Newland:
  Toubiz:
    Sync:
      Neos:
        cache:
          cloudflare:
            zoneId: 'MY_ZONE_ID'
            apiToken: 'MY_CUSTOM_GENERATED_NON_ADMIN_API_TOKEN'
```

To enable the backend module with the "purge everything" button:
```
Neos:
  Neos:
    modules:
      management:
        submodules:
          toubizSyncCache:
            enabled: true
```

To enable the "purge this page" button on every content page, add the mixin
to your project page node type:
```
'Neos.NodeTypes:Page':
  superTypes:
    'Newland.Toubiz.Sync.Neos:PageCacheMixin': true
```
