<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs! This block will be used as the migration description if getDescription() is not used.
 */
class Version20200217163432 extends AbstractMigration
{

    /**
     * @return string
     */
    public function getDescription()
    {
        return '';
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function up(Schema $schema)
    {
        // this up() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_offer_media_join DROP FOREIGN KEY FK_4C29B4DCFC372AFE');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_benefit DROP FOREIGN KEY FK_73E5D1EADE686795');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_package_media_join DROP FOREIGN KEY FK_1B8AF764BDF5BA6F');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_service (persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', name VARCHAR(255) NOT NULL, type VARCHAR(20) NOT NULL, benefits LONGTEXT NOT NULL COMMENT \'(DC2Type:json)\', minimumnights DOUBLE PRECISION DEFAULT NULL, startingprice DOUBLE PRECISION DEFAULT NULL, startingpricecurrency CHAR(3) DEFAULT NULL, client VARCHAR(255) NOT NULL, durationminutes INT DEFAULT NULL, address VARCHAR(255) DEFAULT NULL, detailurl VARCHAR(255) NOT NULL, originalid VARCHAR(50) NOT NULL, language CHAR(2) DEFAULT NULL, PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_service_media_join (neos_service CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', neos_medium CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', INDEX IDX_81C73B2582004728 (neos_service), INDEX IDX_81C73B255DC266AA (neos_medium), PRIMARY KEY(neos_service, neos_medium)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_service_media_join ADD CONSTRAINT FK_81C73B2582004728 FOREIGN KEY (neos_service) REFERENCES newland_toubiz_sync_neos_domain_model_service (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_service_media_join ADD CONSTRAINT FK_81C73B255DC266AA FOREIGN KEY (neos_medium) REFERENCES newland_toubiz_sync_neos_domain_model_medium (persistence_object_identifier)');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_benefit');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_offer');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_offer_media_join');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_package');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_package_media_join');
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function down(Schema $schema)
    {
        // this down() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_service_media_join DROP FOREIGN KEY FK_81C73B2582004728');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_benefit (persistence_object_identifier CHAR(36) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci` COMMENT \'(DC2Type:guid)\', package CHAR(36) CHARACTER SET utf8mb4 DEFAULT NULL COLLATE `utf8mb4_unicode_ci` COMMENT \'(DC2Type:guid)\', name LONGTEXT CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci`, originalid VARCHAR(50) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci`, INDEX IDX_73E5D1EADE686795 (package), INDEX newland_toubiz_sync_neos_benefit_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_offer (persistence_object_identifier CHAR(36) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci` COMMENT \'(DC2Type:guid)\', name VARCHAR(255) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci`, startingprice DOUBLE PRECISION DEFAULT NULL, startingpricecurrency CHAR(3) CHARACTER SET utf8mb4 DEFAULT NULL COLLATE `utf8mb4_unicode_ci`, durationminutes INT DEFAULT NULL, address VARCHAR(255) CHARACTER SET utf8mb4 DEFAULT NULL COLLATE `utf8mb4_unicode_ci`, originalid VARCHAR(50) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci`, language CHAR(2) CHARACTER SET utf8mb4 DEFAULT NULL COLLATE `utf8mb4_unicode_ci`, detailuri VARCHAR(255) CHARACTER SET utf8mb4 DEFAULT NULL COLLATE `utf8mb4_unicode_ci`, INDEX newland_toubiz_sync_neos_offer_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_offer_media_join (neos_offer CHAR(36) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci` COMMENT \'(DC2Type:guid)\', neos_medium CHAR(36) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci` COMMENT \'(DC2Type:guid)\', INDEX IDX_4C29B4DC5DC266AA (neos_medium), INDEX IDX_4C29B4DCFC372AFE (neos_offer), PRIMARY KEY(neos_offer, neos_medium)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_package (persistence_object_identifier CHAR(36) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci` COMMENT \'(DC2Type:guid)\', name VARCHAR(255) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci`, minimumnights DOUBLE PRECISION DEFAULT NULL, startingprice DOUBLE PRECISION DEFAULT NULL, startingpricecurrency CHAR(3) CHARACTER SET utf8mb4 DEFAULT NULL COLLATE `utf8mb4_unicode_ci`, originalid VARCHAR(50) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci`, client VARCHAR(255) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci`, language CHAR(2) CHARACTER SET utf8mb4 DEFAULT NULL COLLATE `utf8mb4_unicode_ci`, detailuri VARCHAR(255) CHARACTER SET utf8mb4 DEFAULT NULL COLLATE `utf8mb4_unicode_ci`, INDEX newland_toubiz_sync_neos_package_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_package_media_join (neos_package CHAR(36) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci` COMMENT \'(DC2Type:guid)\', neos_medium CHAR(36) CHARACTER SET utf8mb4 NOT NULL COLLATE `utf8mb4_unicode_ci` COMMENT \'(DC2Type:guid)\', INDEX IDX_1B8AF7645DC266AA (neos_medium), INDEX IDX_1B8AF764BDF5BA6F (neos_package), PRIMARY KEY(neos_package, neos_medium)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_benefit ADD CONSTRAINT FK_73E5D1EADE686795 FOREIGN KEY (package) REFERENCES newland_toubiz_sync_neos_domain_model_package (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_offer_media_join ADD CONSTRAINT FK_4C29B4DC5DC266AA FOREIGN KEY (neos_medium) REFERENCES newland_toubiz_sync_neos_domain_model_medium (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_offer_media_join ADD CONSTRAINT FK_4C29B4DCFC372AFE FOREIGN KEY (neos_offer) REFERENCES newland_toubiz_sync_neos_domain_model_offer (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_package_media_join ADD CONSTRAINT FK_1B8AF7645DC266AA FOREIGN KEY (neos_medium) REFERENCES newland_toubiz_sync_neos_domain_model_medium (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_package_media_join ADD CONSTRAINT FK_1B8AF764BDF5BA6F FOREIGN KEY (neos_package) REFERENCES newland_toubiz_sync_neos_domain_model_package (persistence_object_identifier)');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_service');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_service_media_join');
    }
}
