<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs! This block will be used as the migration description if getDescription() is not used.
 */
class Version20190909084539 extends AbstractMigration
{

    /**
     * @return string
     */
    public function getDescription()
    {
        return 'Extracts the zip codes of city data into a separate table.';
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function up(Schema $schema)
    {
        // this up() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');
        
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_citydata_zipcodes_join (neos_citydata CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', neos_zipcode CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', INDEX IDX_A9129F8B90A516CE (neos_citydata), INDEX IDX_A9129F8B3691DC38 (neos_zipcode), PRIMARY KEY(neos_citydata, neos_zipcode)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_zipcode (persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', zipcode VARCHAR(5) NOT NULL, country VARCHAR(3) NOT NULL, INDEX newland_toubiz_sync_neos_zipcode_import_ident (zipCode), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_citydata_zipcodes_join ADD CONSTRAINT FK_A9129F8B90A516CE FOREIGN KEY (neos_citydata) REFERENCES newland_toubiz_sync_neos_domain_model_citydata (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_citydata_zipcodes_join ADD CONSTRAINT FK_A9129F8B3691DC38 FOREIGN KEY (neos_zipcode) REFERENCES newland_toubiz_sync_neos_domain_model_zipcode (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_citydata DROP zipcodes');
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function down(Schema $schema)
    {
        // this down() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');
        
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_citydata_zipcodes_join DROP FOREIGN KEY FK_A9129F8B3691DC38');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_citydata_zipcodes_join');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_zipcode');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_citydata ADD zipcodes LONGTEXT DEFAULT NULL COLLATE utf8mb4_unicode_ci COMMENT \'(DC2Type:array)\'');
    }
}
