<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Drops most relationships between models.
 * For more information about this see the changelog about version 1.11.3
 */
class Version20190711125731 extends AbstractMigration
{

    /**
     * @return string
     */
    public function getDescription()
    {
        return '';
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function up(Schema $schema)
    {
        // this up() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->addSql('UPDATE newland_toubiz_sync_neos_domain_model_article SET mainaddress=NULL');
        $this->addSql('UPDATE newland_toubiz_sync_neos_domain_model_article SET mainmedium=NULL');
        $this->addSql('UPDATE newland_toubiz_sync_neos_domain_model_event SET location=NULL');
        $this->addSql('UPDATE newland_toubiz_sync_neos_domain_model_event SET organizer=NULL');

        $this->addSql('DELETE FROM newland_toubiz_sync_neos_domain_model_article_addresses_join');
        $this->addSql('DELETE FROM newland_toubiz_sync_neos_domain_model_article_files_join');
        $this->addSql('DELETE FROM newland_toubiz_sync_neos_domain_model_article_media_join');

        $this->addSql('DELETE FROM newland_toubiz_sync_neos_domain_model_event_eventtags_join');
        $this->addSql('DELETE FROM newland_toubiz_sync_neos_domain_model_event_media_join');
        $this->addSql('DELETE FROM newland_toubiz_sync_neos_domain_model_package_media_join');

        $this->addSql('DELETE FROM newland_toubiz_sync_neos_domain_model_address');
        $this->addSql('DELETE FROM newland_toubiz_sync_neos_domain_model_file');
        $this->addSql('DELETE FROM newland_toubiz_sync_neos_domain_model_medium');
        $this->addSql('DELETE FROM newland_toubiz_sync_neos_domain_model_eventtag');
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function down(Schema $schema)
    {
        // Well, there's nothing to do here.
    }
}
