<?php declare(strict_types=1);

/*
 * Copyright (c) 2024, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Sync\Neos\ViewHelpers\Link;

use Neos\Flow\Mvc\ActionRequest;
use Neos\FluidAdaptor\ViewHelpers\Link\ActionViewHelper;

class BackendActionViewHelper extends ActionViewHelper
{
    public function render()
    {
        /** @var ActionRequest $actionRequest */
        $actionRequest = $this->controllerContext->getRequest();
        $moduleArguments = $this->arguments['arguments'];
        $moduleArguments['@action'] = 'index';

        $uriBuilder = clone ($this->controllerContext->getUriBuilder());
        $uriBuilder->setRequest($actionRequest->getMainRequest());
        $arguments = [
            'module' => 'management/toubizSyncConfiguration',
            'moduleArguments' => $moduleArguments,
        ];

        $uri = $uriBuilder
            ->uriFor('index', $arguments, 'Backend\Module', 'Neos.Neos');

        $this->tag->addAttribute('href', $uri);
        $this->tag->setContent($this->renderChildren());
        $this->tag->forceClosingTag(true);

        return $this->tag->render();
    }
}
