<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Utility;

class NumberUtility
{

    /**
     * Checks if 2 numbers are roughly equal to each other. 2 numbers are declared roughly equal if they
     * are within the given delta of each other.
     */
    public static function roughlyEquals(float $a, float $b, float $leeway): bool
    {
        return ($a - $leeway) < $b && ($a + $leeway) > $b;
    }
}
