<?php declare(strict_types=1);

/*
 * Copyright (c) 2024, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Sync\Neos\Importer;

use Newland\Toubiz\Api\ObjectAdapter\HasMarketingPriceInterface;

trait MapsMarketingPrice
{
    private function mapMarketingPrice(HasMarketingPriceInterface $data): ?array
    {
        $priceInformation = $data->getPriceInformation();
        if ($priceInformation) {
            return [
                'prefix' => $data->getMarketingPricePrefix($priceInformation),
                'value' => $data->getMarketingPriceValue($priceInformation),
                'currency' => $data->getMarketingPriceCurrency($priceInformation),
                'comment' => $data->getMarketingPriceComment($priceInformation),
            ];
        }

        return null;
    }
}
