<?php declare(strict_types=1);

/*
 * Copyright (c) 2024, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Sync\Neos\Domain\Repository;

trait FindsByOriginalIds
{
    public function findByOriginalIds(array $ids): iterable
    {
        if (empty($ids)) {
            return [];
        }

        $queryBuilder = $this->createQueryBuilder($this->getTableAlias());

        return $queryBuilder
            ->select()
            ->where($queryBuilder->expr()->in($this->getTableAlias() . '.originalId', $ids))
            ->getQuery()
            ->execute();
    }
}
