<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Domain\Model;

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Entity()
 */
class Uri extends AbstractEntity
{

    /** @var string */
    protected $uri;

    /**
     * @var string|null
     * @ORM\Column(nullable=true)
     */
    protected $label;

    /**
     * @ORM\ManyToOne(inversedBy="bookingUris")
     * @var Article|null
     */
    protected $articleAsBookingUri;


    public function getUri(): string
    {
        return $this->uri;
    }

    public function setUri(string $uri): void
    {
        $this->uri = $uri;
    }

    public function getLabel(): ?string
    {
        return $this->label;
    }

    public function setLabel(?string $label): void
    {
        $this->label = $label;
    }

    public function getArticleAsBookingUri(): ?Article
    {
        return $this->articleAsBookingUri;
    }

    public function setArticleAsBookingUri(?Article $articleAsBookingUri): void
    {
        $this->articleAsBookingUri = $articleAsBookingUri;
    }
}
