<?php declare(strict_types = 1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model\Traits;

use Doctrine\ORM\Mapping as ORM;

trait UrlIdentifierTrait
{

    /**
     * @var string|null
     * @ORM\Column(type="string", length=10, nullable=true, unique=true)
     */
    protected $urlIdentifier;

    public function setUrlIdentifier(string $generatedId): void
    {
        if (!$this->urlIdentifier) {
            $this->urlIdentifier = substr(md5($generatedId), 0, 10);
        }
    }

    public function getUrlIdentifier(): ?string
    {
        return $this->urlIdentifier;
    }
}
