<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Domain\Model\Traits;

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Model\RawJson;

trait SavesRawJson
{
    /**
     * @var RawJson|null
     * @ORM\OneToOne(
     *     targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\RawJson",
     *     fetch="EXTRA_LAZY",
     *     orphanRemoval=TRUE,
     *     cascade={"PERSIST", "REMOVE"}
     * )
     */
    protected $rawJsonRelation;

    public function getRawJson(): ?array
    {
        if ($this->rawJsonRelation) {
            return $this->rawJsonRelation->getRawJson();
        }
        return null;
    }

    public function setRawJson(array $rawJson): void
    {
        if (!$this->rawJsonRelation) {
            $this->rawJsonRelation = new RawJson();
        }
        $this->rawJsonRelation->setRawJson($rawJson);
    }
}
