<?php declare(strict_types=1);

/*
 * Copyright (c) 2024, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Sync\Neos\Domain\Model\Traits;

use Doctrine\ORM\Mapping as ORM;

trait HasMarketingPrice
{
    /**
     * @var array
     * @ORM\Column(type="json", nullable=true)
     */
    protected $marketingPrice;

    public function getMarketingPrice(): ?array
    {
        return $this->marketingPrice;
    }

    public function setMarketingPrice(?array $marketingPrice): void
    {
        $this->marketingPrice = $marketingPrice;
    }
}
