<?php declare(strict_types=1);

/*
 * Copyright (c) 2024, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Sync\Neos\Domain\Model\Traits;

use Doctrine\ORM\Mapping as ORM;

trait HasLastModifiedAt
{
    /**
     * @ORM\Column(nullable=true)
     * @var \DateTime|null
     */
    protected $lastModifiedAt;

    public function getLastModifiedAt(): ?\DateTime
    {
        return $this->lastModifiedAt;
    }

    public function setLastModifiedAt(?\DateTime $lastModifiedAt): void
    {
        $this->lastModifiedAt = $lastModifiedAt;
    }
}
