<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Domain\Model;
use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Model\Traits\PersistenceObjectIdentifier;

/**
 * @Flow\Entity
 */
class RawJson
{
    use PersistenceObjectIdentifier;

    /**
     * @var array
     * @ORM\Column(type="json")
     */
    protected $rawJson = [];

    public function getRawJson(): ?array
    {
        return $this->rawJson;
    }

    public function setRawJson(array $rawJson): void
    {
        $this->rawJson = $rawJson;
    }
}
