<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use JsonSerializable;
use Newland\Toubiz\Api\ObjectAdapter\BrochureAdapterInterface;

/**
 * A collection of Brochure data.
 * @deprecated This model will be removed in the future.
 */
class Brochure implements JsonSerializable
{

    /**
     * @var string
     */
    protected $externalId;

    /**
     * @var \DateTime
     */
    protected $lastChange;

    /**
     * @var string
     */
    protected $title;

    /**
     * @var string
     */
    protected $description;

    /**
     * @var string
     */
    protected $type;

    /**
     * @var float
     */
    protected $weight;

    /**
     * @var int
     */
    protected $flagStatus;

    /**
     * @var int
     */
    protected $prospectCount;

    /**
     * @var string
     */
    protected $size;

    /**
     * @var string
     */
    protected $address;

    /**
     * @var array
     */
    protected $locations;

    /**
     * @var array
     */
    protected $regions;

    /**
     * @var array
     */
    protected $languages;

    /**
     * @var array
     */
    protected $categories;

    /**
     * @var array
     */
    protected $targets;

    /**
     * @var array
     */
    protected $images;

    /**
     * @var array
     */
    protected $files;

    /**
     * @var array
     */
    protected $externalLinks;

    public function getExternalId(): string
    {
        return $this->externalId;
    }

    public function setExternalId(string $externalId): void
    {
        $this->externalId = $externalId;
    }

    /**
     * @return \DateTime
     */
    public function getLastChange(): \DateTime
    {
        return $this->lastChange;
    }

    public function setLastChange(\DateTime $lastChange): void
    {
        $this->lastChange = $lastChange;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getWeight(): float
    {
        return $this->weight;
    }

    public function getFlagStatus(): int
    {
        return $this->flagStatus;
    }

    public function setFlagStatus(int $flagStatus): void
    {
        $this->flagStatus = $flagStatus;
    }

    public function getProspectCount(): int
    {
        return $this->prospectCount;
    }

    public function getSize(): string
    {
        return $this->size;
    }


    public function getAddress(): string
    {
        return $this->address;
    }

    public function getLocations(): array
    {
        return $this->locations;
    }

    public function getRegions(): array
    {
        return $this->regions;
    }

    public function getLanguages(): array
    {
        return $this->languages;
    }

    public function getCategories(): array
    {
        return $this->categories;
    }

    public function getTargets(): array
    {
        return $this->targets;
    }

    public function getImages(): array
    {
        return $this->images;
    }

    public function getFiles(): array
    {
        return $this->files;
    }

    public function getExternalLinks(): array
    {
        return $this->externalLinks;
    }

    public function fillFromAdapter(BrochureAdapterInterface $data): self
    {
        $this->externalId = $data->getExternalId();
        $this->lastChange = $data->getLastChange();
        $this->title = $data->getTitle();
        $this->description = $data->getDescription();
        $this->type = $data->getType();
        $this->weight = $data->getWeight();
        $this->flagStatus = $data->getFlagStatus();
        $this->prospectCount = $data->getProspectCount();
        $this->size = $data->getSize();
        $this->address = $data->getAddress();
        $this->locations = $data->getLocations();
        $this->regions = $data->getRegion();
        $this->languages = $data->getLanguages();
        $this->images = $data->getImages();
        $this->files = $data->getFiles();

        $this->categories = array_map(
            function ($categoryData) {
                return new BrochureCategory($categoryData);
            },
            $data->getCategories()
        );
        $this->targets = array_map(
            function ($targetData) {
                return new BrochureTarget($targetData);
            },
            $data->getTargets()
        );
        $this->externalLinks = array_map(
            function ($externalLink) {
                return new BrochureExternalLink($externalLink);
            },
            $data->getExternalLinks()
        );

        return $this;
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
