<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Controller\Backend;

use Neos\Error\Messages\Message;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Flow\Mvc\FlashMessageContainer;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Service\Cache\CacheServiceInterface;

class CacheController extends ActionController
{
    /**
     * @var FlashMessageContainer
     * @Flow\Inject()
     */
    protected $messages;

    /**
     * @var CacheServiceInterface
     * @Flow\Inject()
     */
    protected $cacheService;

    public function indexAction(): void
    {
        $this->view->assign('messages', $this->messages->getMessagesAndFlush());
    }

    public function clearGlobalCacheAction(): void
    {
        $this->cacheService->flushGlobalCache();
        $this->messages->addMessage(new Message('Cleared cache', 200));
        $this->redirect('index');
    }
}
