<?php

/*
 * Copyright (c) 2024, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

class Version20240625082842 extends AbstractMigration
{
    public function up(Schema $schema): void
    {
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() != 'mysql',
            'Migration can only be executed safely on "mysql".'
        );

        $this->addSql(
            'ALTER TABLE newland_toubiz_sync_neos_domain_model_article ADD lastmodifiedat DATETIME DEFAULT NULL'
        );
        $this->addSql(
            'ALTER TABLE newland_toubiz_sync_neos_domain_model_event ADD lastmodifiedat DATETIME DEFAULT NULL'
        );
    }

    public function down(Schema $schema): void
    {
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() != 'mysql',
            'Migration can only be executed safely on "mysql".'
        );

        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article DROP lastmodifiedat');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event DROP lastmodifiedat');
    }
}
