<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Model\Traits\PersistenceObjectIdentifier;

/**
 * @Flow\Entity
 */
class SeoInformation
{
    use PersistenceObjectIdentifier;

    /**
     * @ORM\Column(nullable=true)
     * @var string|null
     */
    protected $metaTitle;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @var string|null
     */
    protected $metaDescription;

    /**
     * @ORM\Column(type="boolean", options={ "default": 0 })
     * @var bool
     */
    protected $noIndex;

    /**
     * @ORM\Column(nullable=true)
     * @var string|null
     */
    protected $openGraphTitle;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @var string|null
     */
    protected $openGraphDescription;

    /**
     * @ORM\Column(nullable=true)
     * @var string|null
     */
    protected $openGraphImage;

    public function getMetaTitle(): ?string
    {
        return $this->metaTitle;
    }

    public function setMetaTitle(?string $metaTitle): void
    {
        $this->metaTitle = $metaTitle;
    }

    public function getMetaDescription(): ?string
    {
        return $this->metaDescription;
    }

    public function setMetaDescription(?string $metaDescription): void
    {
        $this->metaDescription = $metaDescription;
    }

    public function isNoIndex(): bool
    {
        return $this->noIndex;
    }

    public function setNoIndex(bool $noIndex): void
    {
        $this->noIndex = $noIndex;
    }

    public function getOpenGraphTitle(): ?string
    {
        return $this->openGraphTitle;
    }

    public function setOpenGraphTitle(?string $openGraphTitle): void
    {
        $this->openGraphTitle = $openGraphTitle;
    }

    public function getOpenGraphDescription(): ?string
    {
        return $this->openGraphDescription;
    }

    public function setOpenGraphDescription(?string $openGraphDescription): void
    {
        $this->openGraphDescription = $openGraphDescription;
    }

    public function getOpenGraphImage(): ?string
    {
        return $this->openGraphImage;
    }

    public function setOpenGraphImage(?string $openGraphImage): void
    {
        $this->openGraphImage = $openGraphImage;
    }
}
