<?php declare(strict_types=1);
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

class Version20230417133033 extends AbstractMigration
{

    public function getDescription(): string
    {
        return 'Add field "maincategory" to articles';
    }

    public function up(Schema $schema): void
    {
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() != 'mysql',
            'Migration can only be executed safely on "mysql".'
        );

        $this->addSql(
            'ALTER TABLE newland_toubiz_sync_neos_domain_model_article ADD maincategory CHAR(36) DEFAULT NULL COMMENT \'(DC2Type:guid)\', DROP sourcename, DROP authorname, CHANGE sourceapiversion sourceapiversion VARCHAR(255) DEFAULT NULL'
        );
        $this->addSql(
            'ALTER TABLE newland_toubiz_sync_neos_domain_model_article ADD CONSTRAINT FK_2D54DF93864F5155 FOREIGN KEY (maincategory) REFERENCES newland_toubiz_sync_neos_domain_model_category (persistence_object_identifier)'
        );
        $this->addSql(
            'CREATE INDEX IDX_2D54DF93864F5155 ON newland_toubiz_sync_neos_domain_model_article (maincategory)'
        );
    }

    public function down(Schema $schema): void
    {
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() != 'mysql',
            'Migration can only be executed safely on "mysql".'
        );

        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article DROP FOREIGN KEY FK_2D54DF93864F5155');
        $this->addSql('DROP INDEX IDX_2D54DF93864F5155 ON newland_toubiz_sync_neos_domain_model_article');
        $this->addSql(
            'ALTER TABLE newland_toubiz_sync_neos_domain_model_article ADD sourcename VARCHAR(255) CHARACTER SET utf8mb4 DEFAULT NULL COLLATE `utf8mb4_unicode_ci`, ADD authorname VARCHAR(255) CHARACTER SET utf8mb4 DEFAULT NULL COLLATE `utf8mb4_unicode_ci`, DROP maincategory, CHANGE sourceapiversion sourceapiversion VARCHAR(15) CHARACTER SET utf8mb4 DEFAULT NULL COLLATE `utf8mb4_unicode_ci`'
        );
    }
}
