<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Configuration;

class ConfigurationAction
{
    /** @var string */
    private $name;

    /** @var string */
    private $icon;

    /** @var string */
    private $color;

    /** @var callable */
    private $action;

    /** @var bool */
    private $persistChanges;

    public function __construct(
        string $name,
        string $icon,
        string $color,
        callable $action,
        bool $persistChanges = true
    ) {
        $this->name = $name;
        $this->action = $action;
        $this->icon = $icon;
        $this->color = $color;
        $this->persistChanges = $persistChanges;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getIcon(): string
    {
        return $this->icon;
    }

    public function getColor(): string
    {
        return $this->color;
    }

    public function getPersistChanges(): bool
    {
        return $this->persistChanges;
    }

    public function invoke(array $configuration): array
    {
        $action = $this->action;
        return $action($configuration);
    }
}
