<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

class Version20230905133329 extends AbstractMigration
{
    public function up(Schema $schema): void
    {
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() != 'mysql',
            'Migration can only be executed safely on "mysql".'
        );

        $this->addSql(
            'ALTER TABLE newland_toubiz_sync_neos_domain_model_article ADD canonicalurl VARCHAR(255) DEFAULT NULL'
        );
        $this->addSql(
            'ALTER TABLE newland_toubiz_sync_neos_domain_model_event ADD canonicalurl VARCHAR(255) DEFAULT NULL'
        );
    }

    public function down(Schema $schema): void
    {
        // this down() migration is autogenerated, please modify it to your needs
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() != 'mysql',
            'Migration can only be executed safely on "mysql".'
        );

        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article DROP canonicalurl');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event DROP canonicalurl');
    }
}
