<?php declare(strict_types=1);

/*
 * Copyright (c) 2024, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Sync\Neos\Importer;

use Newland\Toubiz\Api\ObjectAdapter\SeoInformationAdapterInterface;
use Newland\Toubiz\Sync\Neos\Domain\Model\SeoInformation;
use Newland\Toubiz\Sync\Neos\Domain\Model\Traits\HasSeoInformationInterface;

trait MapsSeoInformation
{
    private function mapSeoInformation(
        SeoInformationAdapterInterface $seoInformationAdapter,
        HasSeoInformationInterface $item
    ): void {
        $seoInformation = $item->getSeoInformation() ?? new SeoInformation();

        $seoInformation->setMetaTitle($seoInformationAdapter->getMetaTitle());
        $seoInformation->setMetaDescription($seoInformationAdapter->getMetaDescription());
        $seoInformation->setNoIndex($seoInformationAdapter->isNoIndex());
        $seoInformation->setOpenGraphTitle($seoInformationAdapter->getOpenGraphTitle());
        $seoInformation->setOpenGraphDescription($seoInformationAdapter->getOpenGraphDescription());
        $seoInformation->setOpenGraphImage($seoInformationAdapter->getOpenGraphImage());

        $item->setSeoInformation($seoInformation);
    }
}
