<?php declare(strict_types=1);
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

class Version20220411135810 extends AbstractMigration
{
    public function getDescription(): string
    {
        return 'Add index to article fields that are relevant for filtering.';
    }

    public function up(Schema $schema): void
    {
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() != 'mysql',
            'Migration can only be executed safely on "mysql".'
        );

        $this->addSql(
            'CREATE INDEX newland_toubiz_sync_neos_article_filtering' .
            ' ON newland_toubiz_sync_neos_domain_model_article (client, maintype, language, hidden)'
        );
    }

    public function down(Schema $schema): void
    {
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() != 'mysql',
            'Migration can only be executed safely on "mysql".'
        );

        $this->addSql(
            'DROP INDEX newland_toubiz_sync_neos_article_filtering ON newland_toubiz_sync_neos_domain_model_article'
        );
    }
}
