<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock;

use DateTimeInterface;
use Newland\Toubiz\Api\ObjectAdapter\EventDateAdapterInterface;

class EventDateAdapterMock implements EventDateAdapterInterface
{

    public $properties = [];

    public function __construct(array $properties)
    {
        $this->properties = $properties;
    }

    public function getBeginsAt(): ?DateTimeInterface
    {
        return $this->properties['beginsAt'] ?? new \DateTime();
    }

    public function getEndsAt(): ?DateTimeInterface
    {
        return $this->properties['endsAt'] ?? new \DateTime();
    }

    public function getBeginsAtSpecificTime(): bool
    {
        return $this->properties['beginsAtSpecificTime'] ?? true;
    }

    public function getEndsAtSpecificTime(): bool
    {
        return $this->properties['endsAtSpecificTime'] ?? true;
    }

    public function getNote(): string
    {
        return $this->properties['note'] ?? '';
    }

    public function getDetailUri(): ?string
    {
        return $this->properties['detailUri'] ?? null;
    }

    public function getExternalId(): string
    {
        return $this->properties['externalId'] ?? '';
    }

    public function isCancelled(): bool
    {
        return $this->properties['cancelled'] ?? false;
    }

    public function isActive(): bool
    {
        return $this->properties['active'] ?? true;
    }

    public function hasDate(): bool
    {
        return ($this->properties['beginsAt'] ?? null) !== null;
    }
}
