<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs! This block will be used as the migration description if getDescription() is not used.
 */
class Version20191216090914 extends AbstractMigration
{

    /**
     * @return string
     */
    public function getDescription()
    {
        return '';
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function up(Schema $schema)
    {
        // this up() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->deleteColumnsCreatedByIncorrectPreviousMigrationToEnsureDatabaseStateIsConsistent();

        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_offer_media_join (neos_offer CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', neos_medium CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', INDEX IDX_4C29B4DCFC372AFE (neos_offer), INDEX IDX_4C29B4DC5DC266AA (neos_medium), PRIMARY KEY(neos_offer, neos_medium)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_offer_media_join ADD CONSTRAINT FK_4C29B4DCFC372AFE FOREIGN KEY (neos_offer) REFERENCES newland_toubiz_sync_neos_domain_model_offer (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_offer_media_join ADD CONSTRAINT FK_4C29B4DC5DC266AA FOREIGN KEY (neos_medium) REFERENCES newland_toubiz_sync_neos_domain_model_medium (persistence_object_identifier)');
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function down(Schema $schema)
    {
        // this down() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->deleteColumnsCreatedByIncorrectPreviousMigrationToEnsureDatabaseStateIsConsistent();

        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_offer_media_join');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_offer ADD previewimage VARCHAR(255) CHARACTER SET utf8mb4 DEFAULT NULL COLLATE `utf8mb4_unicode_ci`');
    }

    private function deleteColumnsCreatedByIncorrectPreviousMigrationToEnsureDatabaseStateIsConsistent(): void
    {
        // Previous migrations that have been deleted in the meantime added incorrect fields.
        // This part of the migration rectifies this by ensuring that these fields are deleted
        // if they exist.
        if ($this->columnExists('newland_toubiz_sync_neos_domain_model_offer', 'media')) {
            $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_offer DROP media');
        }
        if ($this->columnExists('newland_toubiz_sync_neos_domain_model_offer', 'previewimage')) {
            $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_offer DROP previewimage');
        }
    }

    private function columnExists(string $table, string $columnName): bool
    {
        foreach ($this->sm->listTableColumns($table) as $column) {
            if ($column->getName() === $columnName) {
                return true;
            }
        }
        return false;
    }
}
