<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Doctrine\Common\Collections\ArrayCollection;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ServiceConstants;
use Newland\Toubiz\Sync\Neos\Domain\Model\Service;

/**
 * @method Service create(array $attributes = [])
 */
class ServiceFactory extends AbstractFactory
{
    public function make(array $properties = []): Service
    {
        $service = new Service();

        if (array_key_exists('type', $properties)) {
            $service->setType($properties['type']);
        } else {
            $randomKey = array_rand(ServiceConstants::ALL_TYPES);
            $service->setType(ServiceConstants::ALL_TYPES[$randomKey]);
        }

        $service->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $service->setName($properties['name'] ?? $this->faker->name);
        $service->setBenefits($properties['benefits'] ?? $this->faker->words(3, false));
        $service->setMinimumNights($properties['minimumNights'] ?? null);
        $service->setStartingPrice($properties['startingPrice'] ?? null);
        $service->setStartingPriceCurrency($properties['startingPriceCurrency'] ?? null);
        $service->setDurationMinutes($properties['durationMinutes'] ?? null);
        $service->setAddress($properties['address'] ?? null);
        $service->setDetailUrl($properties['detailUrl'] ?? $this->faker->url);
        $service->setClient($properties['client'] ?? $this->faker->word);

        if (array_key_exists('media', $properties)) {
            $service->setMedia(new ArrayCollection($properties['media']));
        }

        return $service;
    }
}
