<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * An order of brochures.
 * @deprecated This model will be removed in the future.
 */
class BrochureOrder
{
    /** @var array */
    protected $data = [];

    /** @var string */
    protected $salutation = '';

    /** @var string */
    protected $firstName = '';

    /** @var string */
    protected $lastName = '';

    /** @var string */
    protected $street = '';

    /** @var string */
    protected $streetNumber = '';

    /** @var string */
    protected $zip = '';

    /** @var string */
    protected $city = '';

    /** @var string */
    protected $country = '';

    /** @var string */
    protected $email = '';

    /** @var string */
    protected $referredBy = '';

    /** @var array */
    protected $brochures = [];

    /** @var string */
    protected $language = 'de';

    /** @var bool */
    protected $newsletter = false;

    public static function fromArray(array $data): BrochureOrder
    {
        $order = new static();
        $order->setSalutation($data['salutation'] ?? '');
        $order->setFirstName($data['firstName'] ?? '');
        $order->setLastName($data['lastName'] ?? '');
        $order->setZip($data['zip'] ?? '');
        $order->setCity($data['city'] ?? '');
        $order->setStreet($data['street'] ?? '');
        $order->setStreetNumber($data['streetNumber'] ?? '');
        $order->setEmail($data['eMail'] ?? '');
        $order->setReferredBy($data['referredBy'] ?? '');
        $order->setReferredBy($data['newsletter'] ?? false);
        $order->setBrochures($data['brochures'] ?? []);
        $order->setLanguage($data['language'] ?? 'de');
        return $order;
    }

    public function getData(): array
    {
        return $this->data;
    }

    public function setData(array $data): void
    {
        $this->data = $data;
    }

    public function getSalutation(): string
    {
        return $this->salutation;
    }

    public function setSalutation(string $salutation): void
    {
        $this->salutation = $salutation;
    }

    public function getFirstName(): string
    {
        return $this->firstName;
    }

    public function setFirstName(string $firstName): void
    {
        $this->firstName = $firstName;
    }

    public function getLastName(): string
    {
        return $this->lastName;
    }

    public function setLastName(string $lastName): void
    {
        $this->lastName = $lastName;
    }

    public function getStreet(): string
    {
        return $this->street;
    }

    public function setStreet(string $street): void
    {
        $this->street = $street;
    }

    public function getStreetNumber(): string
    {
        return $this->streetNumber;
    }

    public function setStreetNumber(string $streetNumber): void
    {
        $this->streetNumber = $streetNumber;
    }

    public function getZip(): string
    {
        return $this->zip;
    }

    public function setZip(string $zip): void
    {
        $this->zip = $zip;
    }

    public function getCity(): string
    {
        return $this->city;
    }

    public function setCity(string $city): void
    {
        $this->city = $city;
    }

    public function getCountry(): string
    {
        return $this->country;
    }

    public function setCountry(string $country): void
    {
        $this->country = $country;
    }

    public function getEmail(): string
    {
        return $this->email;
    }

    public function setEmail(string $email): void
    {
        $this->email = $email;
    }

    public function getReferredBy(): string
    {
        return $this->referredBy;
    }

    public function setReferredBy(string $referredBy): void
    {
        $this->referredBy = $referredBy;
    }

    public function isNewsletter(): bool
    {
        return $this->newsletter;
    }

    public function setNewsletter(bool $newsletter): void
    {
        $this->newsletter = $newsletter;
    }

    public function getBrochures(): array
    {
        return $this->brochures;
    }

    public function setBrochures(array $brochures): void
    {
        $this->brochures = $brochures;
    }

    public function getLanguage(): string
    {
        return $this->language;
    }

    public function setLanguage(string $language): void
    {
        $this->language = $language;
    }
}
