<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Domain\TypeConverter;

use Neos\Flow\ObjectManagement\ObjectManager;
use Neos\Flow\Persistence\Doctrine\Repository;
use Neos\Flow\Property\Exception\TargetNotFoundException;
use Neos\Flow\Property\PropertyMappingConfigurationInterface;
use Neos\Flow\Property\TypeConverter\AbstractTypeConverter;

/**
 * Super class for common entity type converter logic.
 * All concrete converters that convert from a persistence_object_identifier to an entity instance
 * should extend from this class.
 *
 * All they have to do is inject to correct concrete repository as $repository.
 */
abstract class EntityTypeConverter extends AbstractTypeConverter
{
    protected $sourceTypes = [ 'string' ];
    protected $priority = 99;

    /** @var Repository */
    protected $repository;

    public function initializeObject(): void
    {
        $this->targetType = $this->repository->getEntityClassName();
    }

    public function convertFrom(
        $source,
        $targetType,
        array $convertedChildProperties = [],
        PropertyMappingConfigurationInterface $configuration = null
    ) {
        $entity = $this->repository->findByIdentifier((string) $source);

        if ($entity === null) {
            throw new TargetNotFoundException('No record with identifier ' . $source . ' found.');
        }

        return $entity;
    }
}
