<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Domain\Repository;

use Neos\Flow\Persistence\Doctrine\Repository;
use Newland\Toubiz\Sync\Neos\Domain\Model\ExternalId;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Scope("singleton")
 */
class ExternalIdRepository extends Repository
{
    public function findByTypeAndId(string $type, string $id): ?ExternalId
    {
        $expr = $this->entityManager->getExpressionBuilder();
        return $this->createQueryBuilder('externalId')
            ->where($expr->eq('externalId.type', ':type'))
            ->andWhere($expr->eq('externalId.id', ':id'))
            ->setParameters(compact('type', 'id'))
            ->setMaxResults(1)
            ->getQuery()
            ->execute()[0] ?? null;
    }
}
