<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Importer\EventTagImporter;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventTagFactory;
use Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock\EventTagAdapterMock;

class EventTagImporterTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var EventTagImporter */
    protected  $subject;

    /** @var EventTagFactory() */
    protected $factory;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(EventTagImporter::class);
        $this->factory = new EventTagFactory($this->objectManager);
    }


    public function testReusesGivenModelIfSpecified(): void
    {
        $tag = $this->factory->create(['originalId' => 'foo-123']);

        $imported = $this->subject->import(new EventTagAdapterMock(['keywordTypeId'=> 'foo-123']));

        $this->assertEquals($imported->getPersistenceObjectIdentifier(), $tag->getPersistenceObjectIdentifier());
    }
}
