# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.7.3] - 2019-05-14
### Fixed
- Fixed categories being imported with an empty string as language

## [1.7.2] - 2019-05-09
### Added
- Add new signal for URL build

## [1.7.1] - 2019-05-09
### Added
- Tables now have indexes on columns to speed up imports

### Fixed
- Invalid UTF-8 characters are now stripped from incoming data
- Memory leak for article imports has been fixed. Memory consumption does 
  not scale with the number of records anymore.
- Fixed logger not being passed to DbService

## [1.7.0] - 2019-05-08
### Added
- Categories are now language-aware.
- There is now feedback on how many articles were removed during import.
- The order of images for an articles is now saved.
- Add `--only` flag for article synchronize command to allow import of a single article type.

### Changed
- PHP 7.2 and up is now required.

### Fixed 
- Check for translations during import.
- The magic repository methods now respect the current language.
- Fixed incorrect querying when applying filters by client. By not having the `and` 
condition they would override the basic filtering applied.
- Main address no longer blocks removal of articles.
- Attributes are now cleared correctly if there were any previously but not anymore.

## [1.6.1] - 2019-04-18
### Fixed
- Fixed selecting multiple articles when joining to categories
- Imported zip codes now have precedence over calculated ones.

## [1.6.0] - 2019-04-17
### Added
- Article Sync Command now clears cache after it finishes.
- `/redirect/{type}/*` Endpoint to handle generic endpoints as defined by `toubiz-api`.
- Ticket contact field is now imported for events.
- Brochure models and API access has been added
- Social media information for articles
- `events:synchronizeOne` command

### Changed
- `openingTypeFormat` on `Article` has been renamed to `openingTimesFormat`. This is not a breaking
  change as this attribute has not been used anywhere yet.

## [1.5.0] - 2019-04-03
### Added
- Addresses can now use geo location services to retrieve zip codes (for region filtering)
- Every API Service can now be configured with an additional `baseUri` option allowing integrators
  to point Neos to different instances of Services (e.g. TPortal staging server).
- All removal tasks now ask for confirmation before really deleting entities.

### Fixed
- Path cache is now flushed after imports preventing URLs ending in `-1`.
- `doctrine/collections` is now pinned to 1.5.0 to prevent version conflicts.
- Adresses with coordinates close to 0/0 (e.g. 0.02/0.04) are now being ignored.
- A whole import does not fail anymore if a single import step fails.

## [1.4.0] - 2019-03-08
### Added
- Synchronization CommandControllers now emit the `start` `progress` and `end`
  signals that make hooking into the synchronization process easier.
- All synchronization CommandControllers now output status information. Use the `--quiet` to disable them.
- Attribute collections are now countable
- The `articles:synchronize` now has a `--time-to-live` option that deletes records older than x days.
- New `articles:synchronizeTours` command that only synchronizes tours
- New setting `expireDays` that defines the days an deactivated or expired event should stay reachable.

### Fixed
- `CategoryFilter` now correctly sets `toDate` in initialize method
- Fixed query for incorrect field `originalid` in `RegionRepository`
- For gastronomy articles only those with the `online=1` attribute are being imported.

### Removed
- `AbstractCommandController` has been moved to the `Newland.NeosCommon` package

### Migration notes
- Use `php flow snowreport:synchronize` to ensure all requested fields are filled out.

## [1.3.2] 2019-02-07
### Fixed
- Removed migrations that assume the database to be in a defined state as most databases are not in that state.
  For the time being projects / site packages are in charge of migrations as they know their own state best.


