<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

use Newland\Toubiz\Api\ObjectAdapter\BrochureFilterConfigurationAdapterInterface;

class BrochureFilterConfiguration implements \JsonSerializable
{

    /** @var array */
    protected $categories = [];

    /** @var array */
    protected $sources = [];

    /** @var array */
    protected $targets = [];

    /** @var string */
    protected $termsOfService;

    public function __construct(BrochureFilterConfigurationAdapterInterface $adapter)
    {
        $this->termsOfService = $adapter->getTermsOfService();
        foreach ($adapter->getCategories() as $identifier => $label) {
            $this->addCategory($identifier, $label);
        }
        foreach ($adapter->getSources() as $identifier => $label) {
            $this->addSource($identifier, $label);
        }
        foreach ($adapter->getTargets() as $identifier => $label) {
            $this->addTarget($identifier, $label);
        }
    }

    public function addCategory(string $identifier, string $label)
    {
        $this->categories[$identifier] = $label;
    }

    public function addSource(string $identifier, string $label)
    {
        $this->sources[$identifier] = $label;
    }

    public function addTarget(string $identifier, string $label)
    {
        $this->targets[$identifier] = $label;
    }

    public function getCategories(): array
    {
        return $this->categories;
    }

    public function getSources(): array
    {
        return $this->sources;
    }

    public function getTargets(): array
    {
        return $this->targets;
    }

    public function getTermsOfService(): string
    {
        return $this->termsOfService;
    }

    public function jsonSerialize()
    {
        return [
            'categories' => $this->categories,
            'sources' => $this->sources,
            'targets' => $this->targets,
            'termsOfService' => $this->termsOfService,
        ];
    }
}
