<?php
namespace Newland\Toubiz\Sync\Neos\Importer;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\ObjectAdapter\FileAdapterInterface;
use Newland\Toubiz\Sync\Neos\Domain\Model\File;
use Newland\Toubiz\Sync\Neos\Domain\Repository\FileRepository;

/**
 * File importer.
 *
 * @Flow\Scope("singleton")
 */
class FileImporter extends AbstractImporter
{
    /**
     * @Flow\Inject
     * @var FileRepository
     */
    protected $fileRepository;

    /**
     * Import method.
     *
     * Persist given data by creating new objects or updating existing ones.
     *
     * @param FileAdapterInterface $data
     * @return File
     */
    public function import($data)
    {
        $file = $this->fileRepository->findOneByOriginalId($data->getExternalId());
        $persisted = (bool) $file;

        if (!$file) {
            $file = new File();
        }

        if (!$file->getOriginalId()) {
            $file->setOriginalId($data->getExternalId());
        }

        $file->setName($data->getName());
        $file->setSourceUri($data->getSourceUri());

        if ($persisted) {
            $this->fileRepository->update($file);
        } else {
            $this->fileRepository->add($file);
        }
        $this->persistenceManager->persistAll();

        return $file;
    }
}
