<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Repository;

use Doctrine\ORM\QueryBuilder;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Filter\FilterInterface;
use Newland\Toubiz\Sync\Neos\Domain\Filter\OfferFilter;
use Newland\Toubiz\Sync\Neos\Domain\Model\Offer;

/**
 * @Flow\Scope("singleton")
 *
 * @method Offer|null findOneByOriginalId(string $originalId)
 * @method Offer|null findOneBy(array $where)
 */
class OfferRepository extends AbstractRepository
{

    /**
     * @param OfferFilter $filter
     * @param QueryBuilder $query
     * @return QueryBuilder
     */
    protected function applyFilter(FilterInterface $filter, QueryBuilder $query): QueryBuilder
    {
        $this->applyBasicFilter($filter, $query);

        $offers = $filter->getOffers();
        if (!empty($offers)) {
            $query->where(
                $query->expr()->in('offer.Persistence_Object_Identifier', $offers)
            );
        }

        return $query;
    }
}
