<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;

/**
 * A package is a bundle of bookable hotels and services that are sold together.
 *
 * @Flow\Entity()
 */
class Package extends AbstractEntity
{

    /**
     * @var string
     */
    protected $name;

    /**
     * @ORM\ManyToMany(targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\Medium", inversedBy="packages",
     *     fetch="LAZY",
     *     cascade={"persist"})
     * @var Collection<Medium>
     */
    protected $media;

    /**
     * @ORM\OneToMany(targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\Benefit", mappedBy="package", fetch="LAZY",
     *     cascade={"persist", "remove"})
     * @var Collection<Benefit>
     */
    protected $benefits;

    /**
     * @var float
     * @ORM\Column(type="float", nullable=true)
     */
    protected $minimumNights;

    /**
     * @var float
     * @ORM\Column(type="float", nullable=true)
     */
    protected $startingPrice;
    /**
     * @var string
     */
    protected $client;

    /**
     * ISO-4217 currency code.
     *
     * @var string
     * @ORM\Column(type="string", length=3, options={"fixed" = true}, nullable=true)
     */
    protected $startingPriceCurrency;

    public function __construct()
    {
        $this->media = new ArrayCollection();
        $this->benefits = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name)
    {
        $this->name = $name;
    }

    /**
     * @return Collection
     */
    public function getMedia(): Collection
    {
        return $this->media;
    }

    /**
     * @param Collection $media
     */
    public function setMedia(Collection $media)
    {
        $this->media = $media;
    }

    /**
     * @return Collection
     */
    public function getBenefits(): Collection
    {
        return $this->benefits;
    }

    /**
     * @param Collection $benefits
     */
    public function setBenefits(Collection $benefits)
    {
        $this->benefits = $benefits;
    }

    /**
     * @return float
     */
    public function getMinimumNights()
    {
        return $this->minimumNights;
    }

    /**
     * @param float $minimumNights
     */
    public function setMinimumNights(float $minimumNights)
    {
        $this->minimumNights = $minimumNights;
    }

    /**
     * @return float
     */
    public function getStartingPrice()
    {
        return $this->startingPrice;
    }

    /**
     * @param float $startingPrice
     */
    public function setStartingPrice(float $startingPrice)
    {
        $this->startingPrice = $startingPrice;
    }

    /**
     * @return string
     */
    public function getStartingPriceCurrency()
    {
        return $this->startingPriceCurrency;
    }

    /**
     * @param string $startingPriceCurrency
     */
    public function setStartingPriceCurrency(string $startingPriceCurrency)
    {
        $this->startingPriceCurrency = $startingPriceCurrency;
    }

    public function getClient(): string
    {
        return $this->client;
    }

    /**
     * @param string $client
     * @return void
     */
    public function setClient(string $client)
    {
        $this->client = $client;
    }
}
