<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

use CrEOF\Spatial\PHP\Types\AbstractGeometry;
use CrEOF\Spatial\PHP\Types\Geometry\Polygon;
use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Entity
 */
class Geometry
{
    const TYPE_ZIP = 'zip';

    /**
     * @var string
     */
    protected $type;

    /**
     * @var string
     */
    protected $label;

    /**
     * @var AbstractGeometry
     * @ORM\Column(type="geometry")
     */
    protected $geometry;

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type)
    {
        $this->type = $type;
    }

    public function getLabel(): string
    {
        return $this->label;
    }

    public function setLabel(string $label)
    {
        $this->label = $label;
    }

    public function getGeometry(): AbstractGeometry
    {
        return $this->geometry;
    }

    public function setGeometry(AbstractGeometry $geometry)
    {
        $this->geometry = $geometry;
    }
}
