<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

use Neos\Flow\Annotations as Flow;
use Doctrine\ORM\Mapping as ORM;

/**
 * Represents a single benefit of a Package.
 * Examples for benefits may be
 * - Includes WiFi
 * - All inclusive
 *
 * @Flow\Entity()
 */
class Benefit extends AbstractEntity
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var Package
     * @ORM\ManyToOne(targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\Package", inversedBy="benefits")
     */
    protected $package;

    public function __toString(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name)
    {
        $this->name = $name;
    }

    /**
     * @return Package
     */
    public function getPackage()
    {
        return $this->package;
    }

    /**
     * @param Package $package
     */
    public function setPackage(Package $package)
    {
        $this->package = $package;
    }
}
