<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;

/**
 * A tag of an event.
 *
 * @Flow\Entity
 */
class EventTag extends AbstractEntity
{

    /**
     * @var string
     * @ORM\Column(type="text")
     */
    protected $keyword;


    /**
     * @ORM\ManyToMany(targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Event", mappedBy="eventTags", fetch="LAZY")
     * @var Collection<Event>
     */
    protected $events;


    public function __construct()
    {
        $this->events = new ArrayCollection();
    }

    /**
     * @return Collection
     */
    public function getEvents(): Collection
    {
        return $this->events;
    }

    /**
     * @param string $keyword
     * @return void
     */
    public function setKeyword(string $keyword)
    {
        $this->keyword = $keyword;
    }

    /**
     * @return string
     */
    public function getKeyword()
    {
        return $this->keyword;
    }
}
