<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
 use Neos\Flow\Annotations as Flow;

/**
 * A file.
 *
 * @Flow\Entity
 */
class File extends AbstractEntity
{
    /**
     * @var string Name of the file.
     */
    protected $name;

    /**
     * @var string Source URI.
     * @ORM\Column(type="text")
     */
    protected $sourceUri;

    /**
     * @ORM\ManyToMany(targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Article", mappedBy="files", fetch="LAZY")
     * @var Collection<Article>
     */
    protected $articles;

    /**
     * @param string $name
     * @return void
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $sourceUri
     * @return void
     */
    public function setSourceUri($sourceUri)
    {
        $this->sourceUri = $sourceUri;
    }

    /**
     * @return string
     */
    public function getSourceUri()
    {
        return $this->sourceUri;
    }
}
