<?php
namespace Newland\Toubiz\Sync\Neos\Service;

/*
 * This file is part of the "toubiz-packages-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Configuration\ConfigurationManager;
use Neos\Flow\Configuration\Exception\InvalidConfigurationException;

class PackageClientFilterService
{
    /**
     * @var ConfigurationManager
     * @Flow\Inject
     */
    protected $configurationManager;

    public function getClientBySite(string $site)
    {
        $configuration = $this->getConfiguration();

        if (!is_array($configuration)) {
            throw new InvalidConfigurationException('Invalid client configuration', 1548064901);
        }

        if (!array_key_exists($site, $configuration)) {
            $site = 'Default';
        }

        return $configuration[$site]['client'];
    }

    private function getConfiguration(): array
    {
        return $this->configurationManager->getConfiguration(
            ConfigurationManager::CONFIGURATION_TYPE_SETTINGS,
            'Newland.Toubiz.Packages.Neos.clientFilter'
        );
    }
}
