<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Repository;

use Doctrine\ORM\QueryBuilder;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Filter\FilterInterface;
use Newland\Toubiz\Sync\Neos\Domain\Filter\OfferFilter;
use Newland\Toubiz\Sync\Neos\Domain\Model\Offer;

/**
 * @Flow\Scope("singleton")
 *
 * @method Offer findOneByOriginalId(string $originalId)
 */
class OfferRepository extends AbstractRepository
{

    /**
     * @param OfferFilter|FilterInterface $filter
     * @param QueryBuilder $query
     * @return QueryBuilder
     */
    protected function applyFilter(FilterInterface $filter, QueryBuilder $query): QueryBuilder
    {
        $this->applyBasicFilter($filter, $query);

        if ($filter->hasOffers()) {
            $query->where(
                $query->expr()->in('offer.Persistence_Object_Identifier', $filter->getOffers())
            );
        }

        return $query;
    }
}
