<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\Collection;
use Neos\Flow\Annotations as Flow;
use Doctrine\ORM\Mapping as ORM;

/**
 * An address.
 *
 * @Flow\Entity
 */
class Address extends AbstractEntity
{
    /**
     * @ORM\ManyToMany(targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Article", mappedBy="addresses",
     *     fetch="LAZY")
     * @var Collection<Article>
     */
    protected $articles;

    /**
     * @ORM\OneToMany(targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Article", mappedBy="mainAddress",
     *     fetch="LAZY")
     * @var Collection<Event>
     */
    protected $articlesAsMainAddress;

    /**
     * @ORM\OneToMany(targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Event", mappedBy="location", fetch="LAZY")
     * @var Collection<Event>
     */
    protected $eventsAsLocation;

    /**
     * @ORM\OneToMany(targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Event", mappedBy="organizer", fetch="LAZY")
     * @var Collection<Event>
     */
    protected $eventsAsOrganizer;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $name;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $firstName;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $lastName;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $street;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $zip;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $city;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $country;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $phoneNumber;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $emailAddress;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @var string
     */
    protected $websiteAddress;

    /**
     * @ORM\Column(nullable=true)
     * @var float
     */
    protected $latitude;

    /**
     * @ORM\Column(nullable=true)
     * @var float
     */
    protected $longitude;

    /**
     * @var string $name
     * @return void
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @var string $firstName
     * @return void
     */
    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @var string $lastName
     * @return void
     */
    public function setLastName($lastName)
    {
        $this->lastName = $lastName;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @var string $street
     * @return void
     */
    public function setStreet($street)
    {
        $this->street = $street;
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * @var string $zip
     * @return void
     */
    public function setZip($zip)
    {
        $this->zip = $zip;
    }

    /**
     * @return string
     */
    public function getZip()
    {
        return $this->zip;
    }

    /**
     * @var string $city
     * @return void
     */
    public function setCity($city)
    {
        $this->city = $city;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }

    /**
     * @param string $phoneNumber
     * @return void
     */
    public function setPhoneNumber($phoneNumber)
    {
        $this->phoneNumber = $phoneNumber;
    }

    /**
     * @return string
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }

    /**
     * @param string $emailAddress
     * @return void
     */
    public function setEmailAddress($emailAddress)
    {
        $this->emailAddress = $emailAddress;
    }

    /**
     * @return string
     */
    public function getWebsiteAddress()
    {
        return $this->websiteAddress;
    }

    /**
     * @param string $websiteAddress
     * @return void
     */
    public function setWebsiteAddress($websiteAddress)
    {
        $this->websiteAddress = $websiteAddress;
    }

    /**
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @param string $country
     */
    public function setCountry($country)
    {
        $this->country = $country;
    }

    /**
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * @param float $latitude
     */
    public function setLatitude($latitude)
    {
        $this->latitude = $latitude;
    }

    /**
     * @return bool
     */
    public function hasLatitude()
    {
        return !empty($this->latitude);
    }


    /**
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * @param float $longitude
     */
    public function setLongitude($longitude)
    {
        $this->longitude = $longitude;
    }

    /**
     * @return bool
     */
    public function hasLongitude()
    {
        return !empty($this->longitude);
    }

    /**
     * @return bool
     */
    public function getHasGeocoordinates()
    {
        return ($this->hasLatitude() && $this->hasLongitude());
    }

    public function getFullAddress()
    {
        $parts = [
            $this->name,
            $this->firstName . ' ' . $this->lastName,
            $this->street,
            $this->zip,
            $this->city
        ];

        return implode(', ', array_filter($parts));
    }
}
